/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmBsnLagId;
import org.projectfloodlight.openflow.types.LagId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmBsnLagIdVer14
implements OFOxmBsnLagId {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmBsnLagIdVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 8;
    private static final LagId DEFAULT_VALUE = LagId.NONE;
    private final LagId value;
    static final OFOxmBsnLagIdVer14 DEFAULT = new OFOxmBsnLagIdVer14(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmBsnLagIdVer14Funnel FUNNEL = new OFOxmBsnLagIdVer14Funnel();
    static final Writer WRITER = new Writer();

    OFOxmBsnLagIdVer14(LagId value) {
        if (value == null) {
            throw new NullPointerException("OFOxmBsnLagIdVer14: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 197124L;
    }

    @Override
    public LagId getValue() {
        return this.value;
    }

    @Override
    public MatchField<LagId> getMatchField() {
        return MatchField.BSN_LAG_ID;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<LagId> getCanonical() {
        return this;
    }

    @Override
    public LagId getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.4");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFOxmBsnLagId.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmBsnLagIdVer14(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmBsnLagIdVer14 other = (OFOxmBsnLagIdVer14)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmBsnLagIdVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFOxmBsnLagIdVer14 message) {
            bb.writeInt(197124);
            message.value.write4Bytes(bb);
        }
    }

    static class OFOxmBsnLagIdVer14Funnel
    implements Funnel<OFOxmBsnLagIdVer14> {
        private static final long serialVersionUID = 1L;

        OFOxmBsnLagIdVer14Funnel() {
        }

        public void funnel(OFOxmBsnLagIdVer14 message, PrimitiveSink sink) {
            sink.putInt(197124);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmBsnLagId> {
        Reader() {
        }

        @Override
        public OFOxmBsnLagId readFrom(ByteBuf bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != 197124) {
                throw new OFParseError("Wrong typeLen: Expected=0x30204L(0x30204L), got=" + typeLen);
            }
            LagId value = LagId.read4Bytes(bb);
            OFOxmBsnLagIdVer14 oxmBsnLagIdVer14 = new OFOxmBsnLagIdVer14(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmBsnLagIdVer14);
            }
            return oxmBsnLagIdVer14;
        }
    }

    static class Builder
    implements OFOxmBsnLagId.Builder {
        private boolean valueSet;
        private LagId value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 197124L;
        }

        @Override
        public LagId getValue() {
            return this.value;
        }

        @Override
        public OFOxmBsnLagId.Builder setValue(LagId value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<LagId> getMatchField() {
            return MatchField.BSN_LAG_ID;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<LagId> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.4");
        }

        @Override
        public LagId getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.4");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFOxmBsnLagId build() {
            LagId value;
            LagId lagId = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmBsnLagIdVer14(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmBsnLagId.Builder {
        final OFOxmBsnLagIdVer14 parentMessage;
        private boolean valueSet;
        private LagId value;

        BuilderWithParent(OFOxmBsnLagIdVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 197124L;
        }

        @Override
        public LagId getValue() {
            return this.value;
        }

        @Override
        public OFOxmBsnLagId.Builder setValue(LagId value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<LagId> getMatchField() {
            return MatchField.BSN_LAG_ID;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<LagId> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.4");
        }

        @Override
        public LagId getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.4");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFOxmBsnLagId build() {
            LagId value;
            LagId lagId = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmBsnLagIdVer14(value);
        }
    }
}

