/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmBsnInPorts512;
import org.projectfloodlight.openflow.types.OFBitMask512;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmBsnInPorts512Ver14
implements OFOxmBsnInPorts512 {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmBsnInPorts512Ver14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 68;
    private static final OFBitMask512 DEFAULT_VALUE = OFBitMask512.NONE;
    private final OFBitMask512 value;
    static final OFOxmBsnInPorts512Ver14 DEFAULT = new OFOxmBsnInPorts512Ver14(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmBsnInPorts512Ver14Funnel FUNNEL = new OFOxmBsnInPorts512Ver14Funnel();
    static final Writer WRITER = new Writer();

    OFOxmBsnInPorts512Ver14(OFBitMask512 value) {
        if (value == null) {
            throw new NullPointerException("OFOxmBsnInPorts512Ver14: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 206400L;
    }

    @Override
    public OFBitMask512 getValue() {
        return this.value;
    }

    @Override
    public MatchField<OFBitMask512> getMatchField() {
        return MatchField.BSN_IN_PORTS_512;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<OFBitMask512> getCanonical() {
        return this;
    }

    @Override
    public OFBitMask512 getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.4");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFOxmBsnInPorts512.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmBsnInPorts512Ver14(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmBsnInPorts512Ver14 other = (OFOxmBsnInPorts512Ver14)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmBsnInPorts512Ver14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFOxmBsnInPorts512Ver14 message) {
            bb.writeInt(206400);
            message.value.write64Bytes(bb);
        }
    }

    static class OFOxmBsnInPorts512Ver14Funnel
    implements Funnel<OFOxmBsnInPorts512Ver14> {
        private static final long serialVersionUID = 1L;

        OFOxmBsnInPorts512Ver14Funnel() {
        }

        public void funnel(OFOxmBsnInPorts512Ver14 message, PrimitiveSink sink) {
            sink.putInt(206400);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmBsnInPorts512> {
        Reader() {
        }

        @Override
        public OFOxmBsnInPorts512 readFrom(ByteBuf bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != 206400) {
                throw new OFParseError("Wrong typeLen: Expected=0x32640L(0x32640L), got=" + typeLen);
            }
            OFBitMask512 value = OFBitMask512.read64Bytes(bb);
            OFOxmBsnInPorts512Ver14 oxmBsnInPorts512Ver14 = new OFOxmBsnInPorts512Ver14(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmBsnInPorts512Ver14);
            }
            return oxmBsnInPorts512Ver14;
        }
    }

    static class Builder
    implements OFOxmBsnInPorts512.Builder {
        private boolean valueSet;
        private OFBitMask512 value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 206400L;
        }

        @Override
        public OFBitMask512 getValue() {
            return this.value;
        }

        @Override
        public OFOxmBsnInPorts512.Builder setValue(OFBitMask512 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<OFBitMask512> getMatchField() {
            return MatchField.BSN_IN_PORTS_512;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<OFBitMask512> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.4");
        }

        @Override
        public OFBitMask512 getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.4");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFOxmBsnInPorts512 build() {
            OFBitMask512 value;
            OFBitMask512 oFBitMask512 = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmBsnInPorts512Ver14(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmBsnInPorts512.Builder {
        final OFOxmBsnInPorts512Ver14 parentMessage;
        private boolean valueSet;
        private OFBitMask512 value;

        BuilderWithParent(OFOxmBsnInPorts512Ver14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 206400L;
        }

        @Override
        public OFBitMask512 getValue() {
            return this.value;
        }

        @Override
        public OFOxmBsnInPorts512.Builder setValue(OFBitMask512 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<OFBitMask512> getMatchField() {
            return MatchField.BSN_IN_PORTS_512;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<OFBitMask512> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.4");
        }

        @Override
        public OFBitMask512 getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.4");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFOxmBsnInPorts512 build() {
            OFBitMask512 value;
            OFBitMask512 oFBitMask512 = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmBsnInPorts512Ver14(value);
        }
    }
}

