/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.List;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFHelloElemVersionbitmap;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFHelloElemVersionbitmapVer14
implements OFHelloElemVersionbitmap {
    private static final Logger logger = LoggerFactory.getLogger(OFHelloElemVersionbitmapVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int MINIMUM_LENGTH = 4;
    static final int MAXIMUM_LENGTH = 65535;
    private static final List<U32> DEFAULT_BITMAPS = ImmutableList.of();
    private final List<U32> bitmaps;
    static final OFHelloElemVersionbitmapVer14 DEFAULT = new OFHelloElemVersionbitmapVer14(DEFAULT_BITMAPS);
    static final Reader READER = new Reader();
    static final OFHelloElemVersionbitmapVer14Funnel FUNNEL = new OFHelloElemVersionbitmapVer14Funnel();
    static final Writer WRITER = new Writer();

    OFHelloElemVersionbitmapVer14(List<U32> bitmaps) {
        if (bitmaps == null) {
            throw new NullPointerException("OFHelloElemVersionbitmapVer14: property bitmaps cannot be null");
        }
        this.bitmaps = bitmaps;
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public List<U32> getBitmaps() {
        return this.bitmaps;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFHelloElemVersionbitmap.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFHelloElemVersionbitmapVer14(");
        b.append("bitmaps=").append(this.bitmaps);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFHelloElemVersionbitmapVer14 other = (OFHelloElemVersionbitmapVer14)obj;
        return !(this.bitmaps == null ? other.bitmaps != null : !this.bitmaps.equals(other.bitmaps));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bitmaps == null ? 0 : this.bitmaps.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFHelloElemVersionbitmapVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFHelloElemVersionbitmapVer14 message) {
            int startIndex = bb.writerIndex();
            bb.writeShort(1);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            ChannelUtils.writeList(bb, message.bitmaps);
            int length = bb.writerIndex() - startIndex;
            if (length > 65535) {
                throw new IllegalArgumentException("OFHelloElemVersionbitmapVer14: message length (" + length + ") exceeds maximum (0xFFFF)");
            }
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFHelloElemVersionbitmapVer14Funnel
    implements Funnel<OFHelloElemVersionbitmapVer14> {
        private static final long serialVersionUID = 1L;

        OFHelloElemVersionbitmapVer14Funnel() {
        }

        public void funnel(OFHelloElemVersionbitmapVer14 message, PrimitiveSink sink) {
            sink.putShort((short)1);
            FunnelUtils.putList(message.bitmaps, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFHelloElemVersionbitmap> {
        Reader() {
        }

        @Override
        public OFHelloElemVersionbitmap readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 1) {
                throw new OFParseError("Wrong type: Expected=0x1(0x1), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 4) {
                throw new OFParseError("Wrong length: Expected to be >= 4, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            List<U32> bitmaps = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), U32.READER);
            OFHelloElemVersionbitmapVer14 helloElemVersionbitmapVer14 = new OFHelloElemVersionbitmapVer14(bitmaps);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)helloElemVersionbitmapVer14);
            }
            return helloElemVersionbitmapVer14;
        }
    }

    static class Builder
    implements OFHelloElemVersionbitmap.Builder {
        private boolean bitmapsSet;
        private List<U32> bitmaps;

        Builder() {
        }

        @Override
        public int getType() {
            return 1;
        }

        @Override
        public List<U32> getBitmaps() {
            return this.bitmaps;
        }

        @Override
        public OFHelloElemVersionbitmap.Builder setBitmaps(List<U32> bitmaps) {
            this.bitmaps = bitmaps;
            this.bitmapsSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFHelloElemVersionbitmap build() {
            List<U32> bitmaps;
            List<U32> list = bitmaps = this.bitmapsSet ? this.bitmaps : DEFAULT_BITMAPS;
            if (bitmaps == null) {
                throw new NullPointerException("Property bitmaps must not be null");
            }
            return new OFHelloElemVersionbitmapVer14(bitmaps);
        }
    }

    static class BuilderWithParent
    implements OFHelloElemVersionbitmap.Builder {
        final OFHelloElemVersionbitmapVer14 parentMessage;
        private boolean bitmapsSet;
        private List<U32> bitmaps;

        BuilderWithParent(OFHelloElemVersionbitmapVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 1;
        }

        @Override
        public List<U32> getBitmaps() {
            return this.bitmaps;
        }

        @Override
        public OFHelloElemVersionbitmap.Builder setBitmaps(List<U32> bitmaps) {
            this.bitmaps = bitmaps;
            this.bitmapsSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFHelloElemVersionbitmap build() {
            List bitmaps;
            List list = bitmaps = this.bitmapsSet ? this.bitmaps : this.parentMessage.bitmaps;
            if (bitmaps == null) {
                throw new NullPointerException("Property bitmaps must not be null");
            }
            return new OFHelloElemVersionbitmapVer14(bitmaps);
        }
    }
}

