/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvSubAgentId;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvSubAgentIdVer14
implements OFBsnTlvSubAgentId {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvSubAgentIdVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 8;
    private static final long DEFAULT_VALUE = 0L;
    private final long value;
    static final OFBsnTlvSubAgentIdVer14 DEFAULT = new OFBsnTlvSubAgentIdVer14(0L);
    static final Reader READER = new Reader();
    static final OFBsnTlvSubAgentIdVer14Funnel FUNNEL = new OFBsnTlvSubAgentIdVer14Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvSubAgentIdVer14(long value) {
        this.value = U32.normalize(value);
    }

    @Override
    public int getType() {
        return 38;
    }

    @Override
    public long getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFBsnTlvSubAgentId.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvSubAgentIdVer14(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvSubAgentIdVer14 other = (OFBsnTlvSubAgentIdVer14)obj;
        return this.value == other.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.value ^ this.value >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvSubAgentIdVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvSubAgentIdVer14 message) {
            bb.writeShort(38);
            bb.writeShort(8);
            bb.writeInt(U32.t(message.value));
        }
    }

    static class OFBsnTlvSubAgentIdVer14Funnel
    implements Funnel<OFBsnTlvSubAgentIdVer14> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvSubAgentIdVer14Funnel() {
        }

        public void funnel(OFBsnTlvSubAgentIdVer14 message, PrimitiveSink sink) {
            sink.putShort((short)38);
            sink.putShort((short)8);
            sink.putLong(message.value);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvSubAgentId> {
        Reader() {
        }

        @Override
        public OFBsnTlvSubAgentId readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 38) {
                throw new OFParseError("Wrong type: Expected=0x26(0x26), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long value = U32.f(bb.readInt());
            OFBsnTlvSubAgentIdVer14 bsnTlvSubAgentIdVer14 = new OFBsnTlvSubAgentIdVer14(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvSubAgentIdVer14);
            }
            return bsnTlvSubAgentIdVer14;
        }
    }

    static class Builder
    implements OFBsnTlvSubAgentId.Builder {
        private boolean valueSet;
        private long value;

        Builder() {
        }

        @Override
        public int getType() {
            return 38;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvSubAgentId.Builder setValue(long value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvSubAgentId build() {
            long value = this.valueSet ? this.value : 0L;
            return new OFBsnTlvSubAgentIdVer14(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvSubAgentId.Builder {
        final OFBsnTlvSubAgentIdVer14 parentMessage;
        private boolean valueSet;
        private long value;

        BuilderWithParent(OFBsnTlvSubAgentIdVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 38;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvSubAgentId.Builder setValue(long value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvSubAgentId build() {
            long value = this.valueSet ? this.value : this.parentMessage.value;
            return new OFBsnTlvSubAgentIdVer14(value);
        }
    }
}

