/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvQosPriority;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvQosPriorityVer14
implements OFBsnTlvQosPriority {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvQosPriorityVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 8;
    private static final long DEFAULT_VALUE = 0L;
    private final long value;
    static final OFBsnTlvQosPriorityVer14 DEFAULT = new OFBsnTlvQosPriorityVer14(0L);
    static final Reader READER = new Reader();
    static final OFBsnTlvQosPriorityVer14Funnel FUNNEL = new OFBsnTlvQosPriorityVer14Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvQosPriorityVer14(long value) {
        this.value = U32.normalize(value);
    }

    @Override
    public int getType() {
        return 108;
    }

    @Override
    public long getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFBsnTlvQosPriority.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvQosPriorityVer14(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvQosPriorityVer14 other = (OFBsnTlvQosPriorityVer14)obj;
        return this.value == other.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.value ^ this.value >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvQosPriorityVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvQosPriorityVer14 message) {
            bb.writeShort(108);
            bb.writeShort(8);
            bb.writeInt(U32.t(message.value));
        }
    }

    static class OFBsnTlvQosPriorityVer14Funnel
    implements Funnel<OFBsnTlvQosPriorityVer14> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvQosPriorityVer14Funnel() {
        }

        public void funnel(OFBsnTlvQosPriorityVer14 message, PrimitiveSink sink) {
            sink.putShort((short)108);
            sink.putShort((short)8);
            sink.putLong(message.value);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvQosPriority> {
        Reader() {
        }

        @Override
        public OFBsnTlvQosPriority readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 108) {
                throw new OFParseError("Wrong type: Expected=0x6c(0x6c), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long value = U32.f(bb.readInt());
            OFBsnTlvQosPriorityVer14 bsnTlvQosPriorityVer14 = new OFBsnTlvQosPriorityVer14(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvQosPriorityVer14);
            }
            return bsnTlvQosPriorityVer14;
        }
    }

    static class Builder
    implements OFBsnTlvQosPriority.Builder {
        private boolean valueSet;
        private long value;

        Builder() {
        }

        @Override
        public int getType() {
            return 108;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvQosPriority.Builder setValue(long value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvQosPriority build() {
            long value = this.valueSet ? this.value : 0L;
            return new OFBsnTlvQosPriorityVer14(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvQosPriority.Builder {
        final OFBsnTlvQosPriorityVer14 parentMessage;
        private boolean valueSet;
        private long value;

        BuilderWithParent(OFBsnTlvQosPriorityVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 108;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvQosPriority.Builder setValue(long value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvQosPriority build() {
            long value = this.valueSet ? this.value : this.parentMessage.value;
            return new OFBsnTlvQosPriorityVer14(value);
        }
    }
}

