/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvAnalytics;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvAnalyticsVer14
implements OFBsnTlvAnalytics {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvAnalyticsVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 4;
    static final OFBsnTlvAnalyticsVer14 DEFAULT = new OFBsnTlvAnalyticsVer14();
    static final OFBsnTlvAnalyticsVer14 INSTANCE = new OFBsnTlvAnalyticsVer14();
    static final Reader READER = new Reader();
    static final OFBsnTlvAnalyticsVer14Funnel FUNNEL = new OFBsnTlvAnalyticsVer14Funnel();
    static final Writer WRITER = new Writer();

    private OFBsnTlvAnalyticsVer14() {
    }

    @Override
    public int getType() {
        return 206;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFBsnTlvAnalytics.Builder createBuilder() {
        throw new UnsupportedOperationException("OFBsnTlvAnalyticsVer14 has no mutable properties -- builder unneeded");
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvAnalyticsVer14(");
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvAnalyticsVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvAnalyticsVer14 message) {
            bb.writeShort(206);
            bb.writeShort(4);
        }
    }

    static class OFBsnTlvAnalyticsVer14Funnel
    implements Funnel<OFBsnTlvAnalyticsVer14> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvAnalyticsVer14Funnel() {
        }

        public void funnel(OFBsnTlvAnalyticsVer14 message, PrimitiveSink sink) {
            sink.putShort((short)206);
            sink.putShort((short)4);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvAnalytics> {
        Reader() {
        }

        @Override
        public OFBsnTlvAnalytics readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 206) {
                throw new OFParseError("Wrong type: Expected=0xce(0xce), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 4) {
                throw new OFParseError("Wrong length: Expected=4(4), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - returning shared instance={}", (Object)INSTANCE);
            }
            return INSTANCE;
        }
    }
}

