/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnMiscCapabilities;

public class OFBsnMiscCapabilitiesSerializerVer14 {
    public static final long BSN_MISC_CAP_FEC_VAL = 1L;
    public static final long BSN_MISC_CAP_FEC_FIRE_CODE_VAL = 2L;
    public static final long BSN_MISC_CAP_FEC_REED_SOLOMON_VAL = 4L;
    public static final long BSN_MISC_CAP_FEC_REED_SOLOMON544_VAL = 8L;
    public static final long BSN_MISC_CAP_FEC_DISABLE_VAL = 16L;

    public static Set<OFBsnMiscCapabilities> readFrom(ByteBuf bb) throws OFParseError {
        try {
            return OFBsnMiscCapabilitiesSerializerVer14.ofWireValue(bb.readLong());
        }
        catch (IllegalArgumentException e) {
            throw new OFParseError(e);
        }
    }

    public static void writeTo(ByteBuf bb, Set<OFBsnMiscCapabilities> set) {
        bb.writeLong(OFBsnMiscCapabilitiesSerializerVer14.toWireValue(set));
    }

    public static void putTo(Set<OFBsnMiscCapabilities> set, PrimitiveSink sink) {
        sink.putLong(OFBsnMiscCapabilitiesSerializerVer14.toWireValue(set));
    }

    public static Set<OFBsnMiscCapabilities> ofWireValue(long val) {
        EnumSet<OFBsnMiscCapabilities> set = EnumSet.noneOf(OFBsnMiscCapabilities.class);
        if ((val & 1L) != 0L) {
            set.add(OFBsnMiscCapabilities.BSN_MISC_CAP_FEC);
        }
        if ((val & 2L) != 0L) {
            set.add(OFBsnMiscCapabilities.BSN_MISC_CAP_FEC_FIRE_CODE);
        }
        if ((val & 4L) != 0L) {
            set.add(OFBsnMiscCapabilities.BSN_MISC_CAP_FEC_REED_SOLOMON);
        }
        if ((val & 8L) != 0L) {
            set.add(OFBsnMiscCapabilities.BSN_MISC_CAP_FEC_REED_SOLOMON544);
        }
        if ((val & 0x10L) != 0L) {
            set.add(OFBsnMiscCapabilities.BSN_MISC_CAP_FEC_DISABLE);
        }
        return Collections.unmodifiableSet(set);
    }

    public static long toWireValue(Set<OFBsnMiscCapabilities> set) {
        long wireValue = 0L;
        block7: for (OFBsnMiscCapabilities e : set) {
            switch (e) {
                case BSN_MISC_CAP_FEC: {
                    wireValue |= 1L;
                    continue block7;
                }
                case BSN_MISC_CAP_FEC_FIRE_CODE: {
                    wireValue |= 2L;
                    continue block7;
                }
                case BSN_MISC_CAP_FEC_REED_SOLOMON: {
                    wireValue |= 4L;
                    continue block7;
                }
                case BSN_MISC_CAP_FEC_REED_SOLOMON544: {
                    wireValue |= 8L;
                    continue block7;
                }
                case BSN_MISC_CAP_FEC_DISABLE: {
                    wireValue |= 0x10L;
                    continue block7;
                }
            }
            throw new IllegalArgumentException("Illegal enum value for type OFBsnMiscCapabilities in version 1.4: " + (Object)((Object)e));
        }
        return wireValue;
    }
}

