/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFActionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.action.OFActionSetQueue;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFActionSetQueueVer14
implements OFActionSetQueue {
    private static final Logger logger = LoggerFactory.getLogger(OFActionSetQueueVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 8;
    private static final long DEFAULT_QUEUE_ID = 0L;
    private final long queueId;
    static final OFActionSetQueueVer14 DEFAULT = new OFActionSetQueueVer14(0L);
    static final Reader READER = new Reader();
    static final OFActionSetQueueVer14Funnel FUNNEL = new OFActionSetQueueVer14Funnel();
    static final Writer WRITER = new Writer();

    OFActionSetQueueVer14(long queueId) {
        this.queueId = U32.normalize(queueId);
    }

    @Override
    public OFActionType getType() {
        return OFActionType.SET_QUEUE;
    }

    @Override
    public long getQueueId() {
        return this.queueId;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFActionSetQueue.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFActionSetQueueVer14(");
        b.append("queueId=").append(this.queueId);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFActionSetQueueVer14 other = (OFActionSetQueueVer14)obj;
        return this.queueId == other.queueId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.queueId ^ this.queueId >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFActionSetQueueVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFActionSetQueueVer14 message) {
            bb.writeShort(21);
            bb.writeShort(8);
            bb.writeInt(U32.t(message.queueId));
        }
    }

    static class OFActionSetQueueVer14Funnel
    implements Funnel<OFActionSetQueueVer14> {
        private static final long serialVersionUID = 1L;

        OFActionSetQueueVer14Funnel() {
        }

        public void funnel(OFActionSetQueueVer14 message, PrimitiveSink sink) {
            sink.putShort((short)21);
            sink.putShort((short)8);
            sink.putLong(message.queueId);
        }
    }

    static class Reader
    implements OFMessageReader<OFActionSetQueue> {
        Reader() {
        }

        @Override
        public OFActionSetQueue readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 21) {
                throw new OFParseError("Wrong type: Expected=OFActionType.SET_QUEUE(21), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long queueId = U32.f(bb.readInt());
            OFActionSetQueueVer14 actionSetQueueVer14 = new OFActionSetQueueVer14(queueId);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)actionSetQueueVer14);
            }
            return actionSetQueueVer14;
        }
    }

    static class Builder
    implements OFActionSetQueue.Builder {
        private boolean queueIdSet;
        private long queueId;

        Builder() {
        }

        @Override
        public OFActionType getType() {
            return OFActionType.SET_QUEUE;
        }

        @Override
        public long getQueueId() {
            return this.queueId;
        }

        @Override
        public OFActionSetQueue.Builder setQueueId(long queueId) {
            this.queueId = queueId;
            this.queueIdSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFActionSetQueue build() {
            long queueId = this.queueIdSet ? this.queueId : 0L;
            return new OFActionSetQueueVer14(queueId);
        }
    }

    static class BuilderWithParent
    implements OFActionSetQueue.Builder {
        final OFActionSetQueueVer14 parentMessage;
        private boolean queueIdSet;
        private long queueId;

        BuilderWithParent(OFActionSetQueueVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFActionType getType() {
            return OFActionType.SET_QUEUE;
        }

        @Override
        public long getQueueId() {
            return this.queueId;
        }

        @Override
        public OFActionSetQueue.Builder setQueueId(long queueId) {
            this.queueId = queueId;
            this.queueIdSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFActionSetQueue build() {
            long queueId = this.queueIdSet ? this.queueId : this.parentMessage.queueId;
            return new OFActionSetQueueVer14(queueId);
        }
    }
}

