/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Set;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFStatsRequestFlags;
import org.projectfloodlight.openflow.protocol.OFStatsType;
import org.projectfloodlight.openflow.protocol.OFTableFeatures;
import org.projectfloodlight.openflow.protocol.OFTableFeaturesStatsRequest;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver13.OFStatsRequestFlagsSerializerVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFTableFeaturesVer13;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFTableFeaturesStatsRequestVer13
implements OFTableFeaturesStatsRequest {
    private static final Logger logger = LoggerFactory.getLogger(OFTableFeaturesStatsRequestVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int MINIMUM_LENGTH = 16;
    static final int MAXIMUM_LENGTH = 65535;
    private static final long DEFAULT_XID = 0L;
    private static final Set<OFStatsRequestFlags> DEFAULT_FLAGS = ImmutableSet.of();
    private static final List<OFTableFeatures> DEFAULT_ENTRIES = ImmutableList.of();
    private final long xid;
    private final Set<OFStatsRequestFlags> flags;
    private final List<OFTableFeatures> entries;
    static final OFTableFeaturesStatsRequestVer13 DEFAULT = new OFTableFeaturesStatsRequestVer13(0L, DEFAULT_FLAGS, DEFAULT_ENTRIES);
    static final Reader READER = new Reader();
    static final OFTableFeaturesStatsRequestVer13Funnel FUNNEL = new OFTableFeaturesStatsRequestVer13Funnel();
    static final Writer WRITER = new Writer();

    OFTableFeaturesStatsRequestVer13(long xid, Set<OFStatsRequestFlags> flags, List<OFTableFeatures> entries) {
        if (flags == null) {
            throw new NullPointerException("OFTableFeaturesStatsRequestVer13: property flags cannot be null");
        }
        if (entries == null) {
            throw new NullPointerException("OFTableFeaturesStatsRequestVer13: property entries cannot be null");
        }
        this.xid = U32.normalize(xid);
        this.flags = flags;
        this.entries = entries;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFType getType() {
        return OFType.STATS_REQUEST;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public OFStatsType getStatsType() {
        return OFStatsType.TABLE_FEATURES;
    }

    @Override
    public Set<OFStatsRequestFlags> getFlags() {
        return this.flags;
    }

    @Override
    public List<OFTableFeatures> getEntries() {
        return this.entries;
    }

    @Override
    public OFTableFeaturesStatsRequest.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFTableFeaturesStatsRequestVer13(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("flags=").append(this.flags);
        b.append(", ");
        b.append("entries=").append(this.entries);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFTableFeaturesStatsRequestVer13 other = (OFTableFeaturesStatsRequestVer13)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.flags == null ? other.flags != null : !this.flags.equals(other.flags)) {
            return false;
        }
        return !(this.entries == null ? other.entries != null : !this.entries.equals(other.entries));
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFTableFeaturesStatsRequestVer13 other = (OFTableFeaturesStatsRequestVer13)obj;
        if (this.flags == null ? other.flags != null : !this.flags.equals(other.flags)) {
            return false;
        }
        return !(this.entries == null ? other.entries != null : !this.entries.equals(other.entries));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        result = 31 * result + (this.entries == null ? 0 : this.entries.hashCode());
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        result = 31 * result + (this.entries == null ? 0 : this.entries.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFTableFeaturesStatsRequestVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFTableFeaturesStatsRequestVer13 message) {
            int startIndex = bb.writerIndex();
            bb.writeByte(4);
            bb.writeByte(18);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeInt(U32.t(message.xid));
            bb.writeShort(12);
            OFStatsRequestFlagsSerializerVer13.writeTo(bb, message.flags);
            bb.writeZero(4);
            ChannelUtils.writeList(bb, message.entries);
            int length = bb.writerIndex() - startIndex;
            if (length > 65535) {
                throw new IllegalArgumentException("OFTableFeaturesStatsRequestVer13: message length (" + length + ") exceeds maximum (0xFFFF)");
            }
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFTableFeaturesStatsRequestVer13Funnel
    implements Funnel<OFTableFeaturesStatsRequestVer13> {
        private static final long serialVersionUID = 1L;

        OFTableFeaturesStatsRequestVer13Funnel() {
        }

        public void funnel(OFTableFeaturesStatsRequestVer13 message, PrimitiveSink sink) {
            sink.putByte((byte)4);
            sink.putByte((byte)18);
            sink.putLong(message.xid);
            sink.putShort((short)12);
            OFStatsRequestFlagsSerializerVer13.putTo(message.flags, sink);
            FunnelUtils.putList(message.entries, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFTableFeaturesStatsRequest> {
        Reader() {
        }

        @Override
        public OFTableFeaturesStatsRequest readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 4) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_13(4), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 18) {
                throw new OFParseError("Wrong type: Expected=OFType.STATS_REQUEST(18), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 16) {
                throw new OFParseError("Wrong length: Expected to be >= 16, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            short statsType = bb.readShort();
            if (statsType != 12) {
                throw new OFParseError("Wrong statsType: Expected=OFStatsType.TABLE_FEATURES(12), got=" + statsType);
            }
            Set<OFStatsRequestFlags> flags = OFStatsRequestFlagsSerializerVer13.readFrom(bb);
            bb.skipBytes(4);
            List<OFTableFeatures> entries = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFTableFeaturesVer13.READER);
            OFTableFeaturesStatsRequestVer13 tableFeaturesStatsRequestVer13 = new OFTableFeaturesStatsRequestVer13(xid, flags, entries);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)tableFeaturesStatsRequestVer13);
            }
            return tableFeaturesStatsRequestVer13;
        }
    }

    static class Builder
    implements OFTableFeaturesStatsRequest.Builder {
        private boolean xidSet;
        private long xid;
        private boolean flagsSet;
        private Set<OFStatsRequestFlags> flags;
        private boolean entriesSet;
        private List<OFTableFeatures> entries;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.STATS_REQUEST;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFTableFeaturesStatsRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFStatsType getStatsType() {
            return OFStatsType.TABLE_FEATURES;
        }

        @Override
        public Set<OFStatsRequestFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFTableFeaturesStatsRequest.Builder setFlags(Set<OFStatsRequestFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public List<OFTableFeatures> getEntries() {
            return this.entries;
        }

        @Override
        public OFTableFeaturesStatsRequest.Builder setEntries(List<OFTableFeatures> entries) {
            this.entries = entries;
            this.entriesSet = true;
            return this;
        }

        @Override
        public OFTableFeaturesStatsRequest build() {
            List<OFTableFeatures> entries;
            Set<OFStatsRequestFlags> flags;
            long xid = this.xidSet ? this.xid : 0L;
            Set<OFStatsRequestFlags> set = flags = this.flagsSet ? this.flags : DEFAULT_FLAGS;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            List<OFTableFeatures> list = entries = this.entriesSet ? this.entries : DEFAULT_ENTRIES;
            if (entries == null) {
                throw new NullPointerException("Property entries must not be null");
            }
            return new OFTableFeaturesStatsRequestVer13(xid, flags, entries);
        }
    }

    static class BuilderWithParent
    implements OFTableFeaturesStatsRequest.Builder {
        final OFTableFeaturesStatsRequestVer13 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean flagsSet;
        private Set<OFStatsRequestFlags> flags;
        private boolean entriesSet;
        private List<OFTableFeatures> entries;

        BuilderWithParent(OFTableFeaturesStatsRequestVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.STATS_REQUEST;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFTableFeaturesStatsRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFStatsType getStatsType() {
            return OFStatsType.TABLE_FEATURES;
        }

        @Override
        public Set<OFStatsRequestFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFTableFeaturesStatsRequest.Builder setFlags(Set<OFStatsRequestFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public List<OFTableFeatures> getEntries() {
            return this.entries;
        }

        @Override
        public OFTableFeaturesStatsRequest.Builder setEntries(List<OFTableFeatures> entries) {
            this.entries = entries;
            this.entriesSet = true;
            return this;
        }

        @Override
        public OFTableFeaturesStatsRequest build() {
            List entries;
            Set flags;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            Set set = flags = this.flagsSet ? this.flags : this.parentMessage.flags;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            List list = entries = this.entriesSet ? this.entries : this.parentMessage.entries;
            if (entries == null) {
                throw new NullPointerException("Property entries must not be null");
            }
            return new OFTableFeaturesStatsRequestVer13(xid, flags, entries);
        }
    }
}

