/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmConnTrackingState;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmConnTrackingStateVer13
implements OFOxmConnTrackingState {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmConnTrackingStateVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 8;
    private static final U32 DEFAULT_VALUE = U32.ZERO;
    private final U32 value;
    static final OFOxmConnTrackingStateVer13 DEFAULT = new OFOxmConnTrackingStateVer13(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmConnTrackingStateVer13Funnel FUNNEL = new OFOxmConnTrackingStateVer13Funnel();
    static final Writer WRITER = new Writer();

    OFOxmConnTrackingStateVer13(U32 value) {
        if (value == null) {
            throw new NullPointerException("OFOxmConnTrackingStateVer13: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 119300L;
    }

    @Override
    public U32 getValue() {
        return this.value;
    }

    @Override
    public MatchField<U32> getMatchField() {
        return MatchField.CONN_TRACKING_STATE;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<U32> getCanonical() {
        return this;
    }

    @Override
    public U32 getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.3");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFOxmConnTrackingState.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmConnTrackingStateVer13(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmConnTrackingStateVer13 other = (OFOxmConnTrackingStateVer13)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmConnTrackingStateVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFOxmConnTrackingStateVer13 message) {
            bb.writeInt(119300);
            bb.writeInt(message.value.getRaw());
        }
    }

    static class OFOxmConnTrackingStateVer13Funnel
    implements Funnel<OFOxmConnTrackingStateVer13> {
        private static final long serialVersionUID = 1L;

        OFOxmConnTrackingStateVer13Funnel() {
        }

        public void funnel(OFOxmConnTrackingStateVer13 message, PrimitiveSink sink) {
            sink.putInt(119300);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmConnTrackingState> {
        Reader() {
        }

        @Override
        public OFOxmConnTrackingState readFrom(ByteBuf bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != 119300) {
                throw new OFParseError("Wrong typeLen: Expected=0x1d204L(0x1d204L), got=" + typeLen);
            }
            U32 value = U32.of(bb.readInt());
            OFOxmConnTrackingStateVer13 oxmConnTrackingStateVer13 = new OFOxmConnTrackingStateVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmConnTrackingStateVer13);
            }
            return oxmConnTrackingStateVer13;
        }
    }

    static class Builder
    implements OFOxmConnTrackingState.Builder {
        private boolean valueSet;
        private U32 value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 119300L;
        }

        @Override
        public U32 getValue() {
            return this.value;
        }

        @Override
        public OFOxmConnTrackingState.Builder setValue(U32 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<U32> getMatchField() {
            return MatchField.CONN_TRACKING_STATE;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<U32> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public U32 getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmConnTrackingState build() {
            U32 value;
            U32 u32 = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmConnTrackingStateVer13(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmConnTrackingState.Builder {
        final OFOxmConnTrackingStateVer13 parentMessage;
        private boolean valueSet;
        private U32 value;

        BuilderWithParent(OFOxmConnTrackingStateVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 119300L;
        }

        @Override
        public U32 getValue() {
            return this.value;
        }

        @Override
        public OFOxmConnTrackingState.Builder setValue(U32 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<U32> getMatchField() {
            return MatchField.CONN_TRACKING_STATE;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<U32> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public U32 getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmConnTrackingState build() {
            U32 value;
            U32 u32 = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmConnTrackingStateVer13(value);
        }
    }
}

