/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmConnTrackingIpv6Dst;
import org.projectfloodlight.openflow.types.IPv6Address;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmConnTrackingIpv6DstVer13
implements OFOxmConnTrackingIpv6Dst {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmConnTrackingIpv6DstVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 20;
    private static final IPv6Address DEFAULT_VALUE = IPv6Address.NONE;
    private final IPv6Address value;
    static final OFOxmConnTrackingIpv6DstVer13 DEFAULT = new OFOxmConnTrackingIpv6DstVer13(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmConnTrackingIpv6DstVer13Funnel FUNNEL = new OFOxmConnTrackingIpv6DstVer13Funnel();
    static final Writer WRITER = new Writer();

    OFOxmConnTrackingIpv6DstVer13(IPv6Address value) {
        if (value == null) {
            throw new NullPointerException("OFOxmConnTrackingIpv6DstVer13: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 128528L;
    }

    @Override
    public IPv6Address getValue() {
        return this.value;
    }

    @Override
    public MatchField<IPv6Address> getMatchField() {
        return MatchField.CONN_TRACKING_IPV6_DST;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<IPv6Address> getCanonical() {
        return this;
    }

    @Override
    public IPv6Address getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.3");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFOxmConnTrackingIpv6Dst.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmConnTrackingIpv6DstVer13(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmConnTrackingIpv6DstVer13 other = (OFOxmConnTrackingIpv6DstVer13)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmConnTrackingIpv6DstVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFOxmConnTrackingIpv6DstVer13 message) {
            bb.writeInt(128528);
            message.value.write16Bytes(bb);
        }
    }

    static class OFOxmConnTrackingIpv6DstVer13Funnel
    implements Funnel<OFOxmConnTrackingIpv6DstVer13> {
        private static final long serialVersionUID = 1L;

        OFOxmConnTrackingIpv6DstVer13Funnel() {
        }

        public void funnel(OFOxmConnTrackingIpv6DstVer13 message, PrimitiveSink sink) {
            sink.putInt(128528);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmConnTrackingIpv6Dst> {
        Reader() {
        }

        @Override
        public OFOxmConnTrackingIpv6Dst readFrom(ByteBuf bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != 128528) {
                throw new OFParseError("Wrong typeLen: Expected=0x1f610L(0x1f610L), got=" + typeLen);
            }
            IPv6Address value = IPv6Address.read16Bytes(bb);
            OFOxmConnTrackingIpv6DstVer13 oxmConnTrackingIpv6DstVer13 = new OFOxmConnTrackingIpv6DstVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmConnTrackingIpv6DstVer13);
            }
            return oxmConnTrackingIpv6DstVer13;
        }
    }

    static class Builder
    implements OFOxmConnTrackingIpv6Dst.Builder {
        private boolean valueSet;
        private IPv6Address value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 128528L;
        }

        @Override
        public IPv6Address getValue() {
            return this.value;
        }

        @Override
        public OFOxmConnTrackingIpv6Dst.Builder setValue(IPv6Address value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<IPv6Address> getMatchField() {
            return MatchField.CONN_TRACKING_IPV6_DST;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<IPv6Address> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public IPv6Address getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmConnTrackingIpv6Dst build() {
            IPv6Address value;
            IPv6Address iPv6Address = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmConnTrackingIpv6DstVer13(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmConnTrackingIpv6Dst.Builder {
        final OFOxmConnTrackingIpv6DstVer13 parentMessage;
        private boolean valueSet;
        private IPv6Address value;

        BuilderWithParent(OFOxmConnTrackingIpv6DstVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 128528L;
        }

        @Override
        public IPv6Address getValue() {
            return this.value;
        }

        @Override
        public OFOxmConnTrackingIpv6Dst.Builder setValue(IPv6Address value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<IPv6Address> getMatchField() {
            return MatchField.CONN_TRACKING_IPV6_DST;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<IPv6Address> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public IPv6Address getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmConnTrackingIpv6Dst build() {
            IPv6Address value;
            IPv6Address iPv6Address = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmConnTrackingIpv6DstVer13(value);
        }
    }
}

