/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmBsnUdf0Masked;
import org.projectfloodlight.openflow.protocol.ver13.OFOxmBsnUdf0Ver13;
import org.projectfloodlight.openflow.types.UDF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmBsnUdf0MaskedVer13
implements OFOxmBsnUdf0Masked {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmBsnUdf0MaskedVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 12;
    private static final UDF DEFAULT_VALUE = UDF.ZERO;
    private static final UDF DEFAULT_VALUE_MASK = UDF.ZERO;
    private final UDF value;
    private final UDF mask;
    static final OFOxmBsnUdf0MaskedVer13 DEFAULT = new OFOxmBsnUdf0MaskedVer13(DEFAULT_VALUE, DEFAULT_VALUE_MASK);
    static final Reader READER = new Reader();
    static final OFOxmBsnUdf0MaskedVer13Funnel FUNNEL = new OFOxmBsnUdf0MaskedVer13Funnel();
    static final Writer WRITER = new Writer();

    OFOxmBsnUdf0MaskedVer13(UDF value, UDF mask) {
        if (value == null) {
            throw new NullPointerException("OFOxmBsnUdf0MaskedVer13: property value cannot be null");
        }
        if (mask == null) {
            throw new NullPointerException("OFOxmBsnUdf0MaskedVer13: property mask cannot be null");
        }
        this.value = value;
        this.mask = mask;
    }

    @Override
    public long getTypeLen() {
        return 200968L;
    }

    @Override
    public UDF getValue() {
        return this.value;
    }

    @Override
    public UDF getMask() {
        return this.mask;
    }

    @Override
    public MatchField<UDF> getMatchField() {
        return MatchField.BSN_UDF0;
    }

    @Override
    public boolean isMasked() {
        return true;
    }

    @Override
    public OFOxm<UDF> getCanonical() {
        if (UDF.NO_MASK.equals(this.mask)) {
            return new OFOxmBsnUdf0Ver13(this.value);
        }
        if (UDF.FULL_MASK.equals(this.mask)) {
            return null;
        }
        return this;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFOxmBsnUdf0Masked.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmBsnUdf0MaskedVer13(");
        b.append("value=").append(this.value);
        b.append(", ");
        b.append("mask=").append(this.mask);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmBsnUdf0MaskedVer13 other = (OFOxmBsnUdf0MaskedVer13)obj;
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        return !(this.mask == null ? other.mask != null : !this.mask.equals(other.mask));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.mask == null ? 0 : this.mask.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmBsnUdf0MaskedVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFOxmBsnUdf0MaskedVer13 message) {
            bb.writeInt(200968);
            message.value.write4Bytes(bb);
            message.mask.write4Bytes(bb);
        }
    }

    static class OFOxmBsnUdf0MaskedVer13Funnel
    implements Funnel<OFOxmBsnUdf0MaskedVer13> {
        private static final long serialVersionUID = 1L;

        OFOxmBsnUdf0MaskedVer13Funnel() {
        }

        public void funnel(OFOxmBsnUdf0MaskedVer13 message, PrimitiveSink sink) {
            sink.putInt(200968);
            message.value.putTo(sink);
            message.mask.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmBsnUdf0Masked> {
        Reader() {
        }

        @Override
        public OFOxmBsnUdf0Masked readFrom(ByteBuf bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != 200968) {
                throw new OFParseError("Wrong typeLen: Expected=0x31108L(0x31108L), got=" + typeLen);
            }
            UDF value = UDF.read4Bytes(bb);
            UDF mask = UDF.read4Bytes(bb);
            OFOxmBsnUdf0MaskedVer13 oxmBsnUdf0MaskedVer13 = new OFOxmBsnUdf0MaskedVer13(value, mask);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmBsnUdf0MaskedVer13);
            }
            return oxmBsnUdf0MaskedVer13;
        }
    }

    static class Builder
    implements OFOxmBsnUdf0Masked.Builder {
        private boolean valueSet;
        private UDF value;
        private boolean maskSet;
        private UDF mask;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 200968L;
        }

        @Override
        public UDF getValue() {
            return this.value;
        }

        @Override
        public OFOxmBsnUdf0Masked.Builder setValue(UDF value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public UDF getMask() {
            return this.mask;
        }

        @Override
        public OFOxmBsnUdf0Masked.Builder setMask(UDF mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<UDF> getMatchField() {
            return MatchField.BSN_UDF0;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<UDF> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmBsnUdf0Masked build() {
            UDF mask;
            UDF value;
            UDF uDF = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            UDF uDF2 = mask = this.maskSet ? this.mask : DEFAULT_VALUE_MASK;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmBsnUdf0MaskedVer13(value, mask);
        }
    }

    static class BuilderWithParent
    implements OFOxmBsnUdf0Masked.Builder {
        final OFOxmBsnUdf0MaskedVer13 parentMessage;
        private boolean valueSet;
        private UDF value;
        private boolean maskSet;
        private UDF mask;

        BuilderWithParent(OFOxmBsnUdf0MaskedVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 200968L;
        }

        @Override
        public UDF getValue() {
            return this.value;
        }

        @Override
        public OFOxmBsnUdf0Masked.Builder setValue(UDF value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public UDF getMask() {
            return this.mask;
        }

        @Override
        public OFOxmBsnUdf0Masked.Builder setMask(UDF mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<UDF> getMatchField() {
            return MatchField.BSN_UDF0;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<UDF> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmBsnUdf0Masked build() {
            UDF mask;
            UDF value;
            UDF uDF = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            UDF uDF2 = mask = this.maskSet ? this.mask : this.parentMessage.mask;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmBsnUdf0MaskedVer13(value, mask);
        }
    }
}

