/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvRateLimit;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvRateLimitVer13
implements OFBsnTlvRateLimit {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvRateLimitVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 8;
    private static final long DEFAULT_VALUE = 0L;
    private final long value;
    static final OFBsnTlvRateLimitVer13 DEFAULT = new OFBsnTlvRateLimitVer13(0L);
    static final Reader READER = new Reader();
    static final OFBsnTlvRateLimitVer13Funnel FUNNEL = new OFBsnTlvRateLimitVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvRateLimitVer13(long value) {
        this.value = U32.normalize(value);
    }

    @Override
    public int getType() {
        return 116;
    }

    @Override
    public long getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFBsnTlvRateLimit.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvRateLimitVer13(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvRateLimitVer13 other = (OFBsnTlvRateLimitVer13)obj;
        return this.value == other.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.value ^ this.value >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvRateLimitVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvRateLimitVer13 message) {
            bb.writeShort(116);
            bb.writeShort(8);
            bb.writeInt(U32.t(message.value));
        }
    }

    static class OFBsnTlvRateLimitVer13Funnel
    implements Funnel<OFBsnTlvRateLimitVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvRateLimitVer13Funnel() {
        }

        public void funnel(OFBsnTlvRateLimitVer13 message, PrimitiveSink sink) {
            sink.putShort((short)116);
            sink.putShort((short)8);
            sink.putLong(message.value);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvRateLimit> {
        Reader() {
        }

        @Override
        public OFBsnTlvRateLimit readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 116) {
                throw new OFParseError("Wrong type: Expected=0x74(0x74), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long value = U32.f(bb.readInt());
            OFBsnTlvRateLimitVer13 bsnTlvRateLimitVer13 = new OFBsnTlvRateLimitVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvRateLimitVer13);
            }
            return bsnTlvRateLimitVer13;
        }
    }

    static class Builder
    implements OFBsnTlvRateLimit.Builder {
        private boolean valueSet;
        private long value;

        Builder() {
        }

        @Override
        public int getType() {
            return 116;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvRateLimit.Builder setValue(long value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvRateLimit build() {
            long value = this.valueSet ? this.value : 0L;
            return new OFBsnTlvRateLimitVer13(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvRateLimit.Builder {
        final OFBsnTlvRateLimitVer13 parentMessage;
        private boolean valueSet;
        private long value;

        BuilderWithParent(OFBsnTlvRateLimitVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 116;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvRateLimit.Builder setValue(long value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvRateLimit build() {
            long value = this.valueSet ? this.value : this.parentMessage.value;
            return new OFBsnTlvRateLimitVer13(value);
        }
    }
}

