/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvNextHopIpv4;
import org.projectfloodlight.openflow.types.IPv4Address;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvNextHopIpv4Ver13
implements OFBsnTlvNextHopIpv4 {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvNextHopIpv4Ver13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 8;
    private static final IPv4Address DEFAULT_VALUE = IPv4Address.NONE;
    private final IPv4Address value;
    static final OFBsnTlvNextHopIpv4Ver13 DEFAULT = new OFBsnTlvNextHopIpv4Ver13(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFBsnTlvNextHopIpv4Ver13Funnel FUNNEL = new OFBsnTlvNextHopIpv4Ver13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvNextHopIpv4Ver13(IPv4Address value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvNextHopIpv4Ver13: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 115;
    }

    @Override
    public IPv4Address getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFBsnTlvNextHopIpv4.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvNextHopIpv4Ver13(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvNextHopIpv4Ver13 other = (OFBsnTlvNextHopIpv4Ver13)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvNextHopIpv4Ver13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvNextHopIpv4Ver13 message) {
            bb.writeShort(115);
            bb.writeShort(8);
            message.value.write4Bytes(bb);
        }
    }

    static class OFBsnTlvNextHopIpv4Ver13Funnel
    implements Funnel<OFBsnTlvNextHopIpv4Ver13> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvNextHopIpv4Ver13Funnel() {
        }

        public void funnel(OFBsnTlvNextHopIpv4Ver13 message, PrimitiveSink sink) {
            sink.putShort((short)115);
            sink.putShort((short)8);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvNextHopIpv4> {
        Reader() {
        }

        @Override
        public OFBsnTlvNextHopIpv4 readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 115) {
                throw new OFParseError("Wrong type: Expected=0x73(0x73), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            IPv4Address value = IPv4Address.read4Bytes(bb);
            OFBsnTlvNextHopIpv4Ver13 bsnTlvNextHopIpv4Ver13 = new OFBsnTlvNextHopIpv4Ver13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvNextHopIpv4Ver13);
            }
            return bsnTlvNextHopIpv4Ver13;
        }
    }

    static class Builder
    implements OFBsnTlvNextHopIpv4.Builder {
        private boolean valueSet;
        private IPv4Address value;

        Builder() {
        }

        @Override
        public int getType() {
            return 115;
        }

        @Override
        public IPv4Address getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvNextHopIpv4.Builder setValue(IPv4Address value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvNextHopIpv4 build() {
            IPv4Address value;
            IPv4Address iPv4Address = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvNextHopIpv4Ver13(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvNextHopIpv4.Builder {
        final OFBsnTlvNextHopIpv4Ver13 parentMessage;
        private boolean valueSet;
        private IPv4Address value;

        BuilderWithParent(OFBsnTlvNextHopIpv4Ver13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 115;
        }

        @Override
        public IPv4Address getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvNextHopIpv4.Builder setValue(IPv4Address value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvNextHopIpv4 build() {
            IPv4Address value;
            IPv4Address iPv4Address = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvNextHopIpv4Ver13(value);
        }
    }
}

