/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvIcmpv6Type;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U8;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvIcmpv6TypeVer13
implements OFBsnTlvIcmpv6Type {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvIcmpv6TypeVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 5;
    private static final short DEFAULT_VALUE = 0;
    private final short value;
    static final OFBsnTlvIcmpv6TypeVer13 DEFAULT = new OFBsnTlvIcmpv6TypeVer13(0);
    static final Reader READER = new Reader();
    static final OFBsnTlvIcmpv6TypeVer13Funnel FUNNEL = new OFBsnTlvIcmpv6TypeVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvIcmpv6TypeVer13(short value) {
        this.value = U8.normalize(value);
    }

    @Override
    public int getType() {
        return 204;
    }

    @Override
    public short getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFBsnTlvIcmpv6Type.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvIcmpv6TypeVer13(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvIcmpv6TypeVer13 other = (OFBsnTlvIcmpv6TypeVer13)obj;
        return this.value == other.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.value;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvIcmpv6TypeVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvIcmpv6TypeVer13 message) {
            bb.writeShort(204);
            bb.writeShort(5);
            bb.writeByte((int)U8.t(message.value));
        }
    }

    static class OFBsnTlvIcmpv6TypeVer13Funnel
    implements Funnel<OFBsnTlvIcmpv6TypeVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvIcmpv6TypeVer13Funnel() {
        }

        public void funnel(OFBsnTlvIcmpv6TypeVer13 message, PrimitiveSink sink) {
            sink.putShort((short)204);
            sink.putShort((short)5);
            sink.putShort(message.value);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvIcmpv6Type> {
        Reader() {
        }

        @Override
        public OFBsnTlvIcmpv6Type readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 204) {
                throw new OFParseError("Wrong type: Expected=0xcc(0xcc), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 5) {
                throw new OFParseError("Wrong length: Expected=5(5), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            short value = U8.f(bb.readByte());
            OFBsnTlvIcmpv6TypeVer13 bsnTlvIcmpv6TypeVer13 = new OFBsnTlvIcmpv6TypeVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvIcmpv6TypeVer13);
            }
            return bsnTlvIcmpv6TypeVer13;
        }
    }

    static class Builder
    implements OFBsnTlvIcmpv6Type.Builder {
        private boolean valueSet;
        private short value;

        Builder() {
        }

        @Override
        public int getType() {
            return 204;
        }

        @Override
        public short getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvIcmpv6Type.Builder setValue(short value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvIcmpv6Type build() {
            short value = this.valueSet ? this.value : (short)0;
            return new OFBsnTlvIcmpv6TypeVer13(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvIcmpv6Type.Builder {
        final OFBsnTlvIcmpv6TypeVer13 parentMessage;
        private boolean valueSet;
        private short value;

        BuilderWithParent(OFBsnTlvIcmpv6TypeVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 204;
        }

        @Override
        public short getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvIcmpv6Type.Builder setValue(short value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvIcmpv6Type build() {
            short value = this.valueSet ? this.value : this.parentMessage.value;
            return new OFBsnTlvIcmpv6TypeVer13(value);
        }
    }
}

