/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvExternalNetmask;
import org.projectfloodlight.openflow.types.IPv4Address;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvExternalNetmaskVer13
implements OFBsnTlvExternalNetmask {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvExternalNetmaskVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 8;
    private static final IPv4Address DEFAULT_VALUE = IPv4Address.NONE;
    private final IPv4Address value;
    static final OFBsnTlvExternalNetmaskVer13 DEFAULT = new OFBsnTlvExternalNetmaskVer13(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFBsnTlvExternalNetmaskVer13Funnel FUNNEL = new OFBsnTlvExternalNetmaskVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvExternalNetmaskVer13(IPv4Address value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvExternalNetmaskVer13: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 25;
    }

    @Override
    public IPv4Address getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFBsnTlvExternalNetmask.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvExternalNetmaskVer13(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvExternalNetmaskVer13 other = (OFBsnTlvExternalNetmaskVer13)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvExternalNetmaskVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvExternalNetmaskVer13 message) {
            bb.writeShort(25);
            bb.writeShort(8);
            message.value.write4Bytes(bb);
        }
    }

    static class OFBsnTlvExternalNetmaskVer13Funnel
    implements Funnel<OFBsnTlvExternalNetmaskVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvExternalNetmaskVer13Funnel() {
        }

        public void funnel(OFBsnTlvExternalNetmaskVer13 message, PrimitiveSink sink) {
            sink.putShort((short)25);
            sink.putShort((short)8);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvExternalNetmask> {
        Reader() {
        }

        @Override
        public OFBsnTlvExternalNetmask readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 25) {
                throw new OFParseError("Wrong type: Expected=0x19(0x19), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            IPv4Address value = IPv4Address.read4Bytes(bb);
            OFBsnTlvExternalNetmaskVer13 bsnTlvExternalNetmaskVer13 = new OFBsnTlvExternalNetmaskVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvExternalNetmaskVer13);
            }
            return bsnTlvExternalNetmaskVer13;
        }
    }

    static class Builder
    implements OFBsnTlvExternalNetmask.Builder {
        private boolean valueSet;
        private IPv4Address value;

        Builder() {
        }

        @Override
        public int getType() {
            return 25;
        }

        @Override
        public IPv4Address getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvExternalNetmask.Builder setValue(IPv4Address value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvExternalNetmask build() {
            IPv4Address value;
            IPv4Address iPv4Address = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvExternalNetmaskVer13(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvExternalNetmask.Builder {
        final OFBsnTlvExternalNetmaskVer13 parentMessage;
        private boolean valueSet;
        private IPv4Address value;

        BuilderWithParent(OFBsnTlvExternalNetmaskVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 25;
        }

        @Override
        public IPv4Address getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvExternalNetmask.Builder setValue(IPv4Address value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvExternalNetmask build() {
            IPv4Address value;
            IPv4Address iPv4Address = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvExternalNetmaskVer13(value);
        }
    }
}

