/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnGentableDescStatsEntry;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.GenTableId;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnGentableDescStatsEntryVer13
implements OFBsnGentableDescStatsEntry {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnGentableDescStatsEntryVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 48;
    private static final String DEFAULT_NAME = "";
    private static final long DEFAULT_BUCKETS_SIZE = 0L;
    private static final long DEFAULT_MAX_ENTRIES = 0L;
    private final GenTableId tableId;
    private final String name;
    private final long bucketsSize;
    private final long maxEntries;
    static final Reader READER = new Reader();
    static final OFBsnGentableDescStatsEntryVer13Funnel FUNNEL = new OFBsnGentableDescStatsEntryVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnGentableDescStatsEntryVer13(GenTableId tableId, String name, long bucketsSize, long maxEntries) {
        if (tableId == null) {
            throw new NullPointerException("OFBsnGentableDescStatsEntryVer13: property tableId cannot be null");
        }
        if (name == null) {
            throw new NullPointerException("OFBsnGentableDescStatsEntryVer13: property name cannot be null");
        }
        this.tableId = tableId;
        this.name = name;
        this.bucketsSize = U32.normalize(bucketsSize);
        this.maxEntries = U32.normalize(maxEntries);
    }

    @Override
    public GenTableId getTableId() {
        return this.tableId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getBucketsSize() {
        return this.bucketsSize;
    }

    @Override
    public long getMaxEntries() {
        return this.maxEntries;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFBsnGentableDescStatsEntry.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnGentableDescStatsEntryVer13(");
        b.append("tableId=").append(this.tableId);
        b.append(", ");
        b.append("name=").append(this.name);
        b.append(", ");
        b.append("bucketsSize=").append(this.bucketsSize);
        b.append(", ");
        b.append("maxEntries=").append(this.maxEntries);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnGentableDescStatsEntryVer13 other = (OFBsnGentableDescStatsEntryVer13)obj;
        if (this.tableId == null ? other.tableId != null : !this.tableId.equals(other.tableId)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.bucketsSize != other.bucketsSize) {
            return false;
        }
        return this.maxEntries == other.maxEntries;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.tableId == null ? 0 : this.tableId.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * (int)(this.bucketsSize ^ this.bucketsSize >>> 32);
        result = 31 * (int)(this.maxEntries ^ this.maxEntries >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnGentableDescStatsEntryVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnGentableDescStatsEntryVer13 message) {
            bb.writeShort(48);
            message.tableId.write2Bytes(bb);
            ChannelUtils.writeFixedLengthString(bb, message.name, 32);
            bb.writeInt(U32.t(message.bucketsSize));
            bb.writeInt(U32.t(message.maxEntries));
            bb.writeZero(4);
        }
    }

    static class OFBsnGentableDescStatsEntryVer13Funnel
    implements Funnel<OFBsnGentableDescStatsEntryVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnGentableDescStatsEntryVer13Funnel() {
        }

        public void funnel(OFBsnGentableDescStatsEntryVer13 message, PrimitiveSink sink) {
            sink.putShort((short)48);
            message.tableId.putTo(sink);
            sink.putUnencodedChars((CharSequence)message.name);
            sink.putLong(message.bucketsSize);
            sink.putLong(message.maxEntries);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnGentableDescStatsEntry> {
        Reader() {
        }

        @Override
        public OFBsnGentableDescStatsEntry readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            int length = U16.f(bb.readShort());
            if (length != 48) {
                throw new OFParseError("Wrong length: Expected=48(48), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            GenTableId tableId = GenTableId.read2Bytes(bb);
            String name = ChannelUtils.readFixedLengthString(bb, 32);
            long bucketsSize = U32.f(bb.readInt());
            long maxEntries = U32.f(bb.readInt());
            bb.skipBytes(4);
            OFBsnGentableDescStatsEntryVer13 bsnGentableDescStatsEntryVer13 = new OFBsnGentableDescStatsEntryVer13(tableId, name, bucketsSize, maxEntries);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnGentableDescStatsEntryVer13);
            }
            return bsnGentableDescStatsEntryVer13;
        }
    }

    static class Builder
    implements OFBsnGentableDescStatsEntry.Builder {
        private boolean tableIdSet;
        private GenTableId tableId;
        private boolean nameSet;
        private String name;
        private boolean bucketsSizeSet;
        private long bucketsSize;
        private boolean maxEntriesSet;
        private long maxEntries;

        Builder() {
        }

        @Override
        public GenTableId getTableId() {
            return this.tableId;
        }

        @Override
        public OFBsnGentableDescStatsEntry.Builder setTableId(GenTableId tableId) {
            this.tableId = tableId;
            this.tableIdSet = true;
            return this;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public OFBsnGentableDescStatsEntry.Builder setName(String name) {
            this.name = name;
            this.nameSet = true;
            return this;
        }

        @Override
        public long getBucketsSize() {
            return this.bucketsSize;
        }

        @Override
        public OFBsnGentableDescStatsEntry.Builder setBucketsSize(long bucketsSize) {
            this.bucketsSize = bucketsSize;
            this.bucketsSizeSet = true;
            return this;
        }

        @Override
        public long getMaxEntries() {
            return this.maxEntries;
        }

        @Override
        public OFBsnGentableDescStatsEntry.Builder setMaxEntries(long maxEntries) {
            this.maxEntries = maxEntries;
            this.maxEntriesSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnGentableDescStatsEntry build() {
            String name;
            if (!this.tableIdSet) {
                throw new IllegalStateException("Property tableId doesn't have default value -- must be set");
            }
            if (this.tableId == null) {
                throw new NullPointerException("Property tableId must not be null");
            }
            String string = name = this.nameSet ? this.name : OFBsnGentableDescStatsEntryVer13.DEFAULT_NAME;
            if (name == null) {
                throw new NullPointerException("Property name must not be null");
            }
            long bucketsSize = this.bucketsSizeSet ? this.bucketsSize : 0L;
            long maxEntries = this.maxEntriesSet ? this.maxEntries : 0L;
            return new OFBsnGentableDescStatsEntryVer13(this.tableId, name, bucketsSize, maxEntries);
        }
    }

    static class BuilderWithParent
    implements OFBsnGentableDescStatsEntry.Builder {
        final OFBsnGentableDescStatsEntryVer13 parentMessage;
        private boolean tableIdSet;
        private GenTableId tableId;
        private boolean nameSet;
        private String name;
        private boolean bucketsSizeSet;
        private long bucketsSize;
        private boolean maxEntriesSet;
        private long maxEntries;

        BuilderWithParent(OFBsnGentableDescStatsEntryVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public GenTableId getTableId() {
            return this.tableId;
        }

        @Override
        public OFBsnGentableDescStatsEntry.Builder setTableId(GenTableId tableId) {
            this.tableId = tableId;
            this.tableIdSet = true;
            return this;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public OFBsnGentableDescStatsEntry.Builder setName(String name) {
            this.name = name;
            this.nameSet = true;
            return this;
        }

        @Override
        public long getBucketsSize() {
            return this.bucketsSize;
        }

        @Override
        public OFBsnGentableDescStatsEntry.Builder setBucketsSize(long bucketsSize) {
            this.bucketsSize = bucketsSize;
            this.bucketsSizeSet = true;
            return this;
        }

        @Override
        public long getMaxEntries() {
            return this.maxEntries;
        }

        @Override
        public OFBsnGentableDescStatsEntry.Builder setMaxEntries(long maxEntries) {
            this.maxEntries = maxEntries;
            this.maxEntriesSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnGentableDescStatsEntry build() {
            String name;
            GenTableId tableId;
            GenTableId genTableId = tableId = this.tableIdSet ? this.tableId : this.parentMessage.tableId;
            if (tableId == null) {
                throw new NullPointerException("Property tableId must not be null");
            }
            String string = name = this.nameSet ? this.name : this.parentMessage.name;
            if (name == null) {
                throw new NullPointerException("Property name must not be null");
            }
            long bucketsSize = this.bucketsSizeSet ? this.bucketsSize : this.parentMessage.bucketsSize;
            long maxEntries = this.maxEntriesSet ? this.maxEntries : this.parentMessage.maxEntries;
            return new OFBsnGentableDescStatsEntryVer13(tableId, name, bucketsSize, maxEntries);
        }
    }
}

