/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFActionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.actionid.OFActionIdPushVlan;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFActionIdPushVlanVer13
implements OFActionIdPushVlan {
    private static final Logger logger = LoggerFactory.getLogger(OFActionIdPushVlanVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 4;
    static final OFActionIdPushVlanVer13 DEFAULT = new OFActionIdPushVlanVer13();
    static final OFActionIdPushVlanVer13 INSTANCE = new OFActionIdPushVlanVer13();
    static final Reader READER = new Reader();
    static final OFActionIdPushVlanVer13Funnel FUNNEL = new OFActionIdPushVlanVer13Funnel();
    static final Writer WRITER = new Writer();

    private OFActionIdPushVlanVer13() {
    }

    @Override
    public OFActionType getType() {
        return OFActionType.PUSH_VLAN;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFActionIdPushVlan.Builder createBuilder() {
        throw new UnsupportedOperationException("OFActionIdPushVlanVer13 has no mutable properties -- builder unneeded");
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFActionIdPushVlanVer13(");
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFActionIdPushVlanVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFActionIdPushVlanVer13 message) {
            bb.writeShort(17);
            bb.writeShort(4);
        }
    }

    static class OFActionIdPushVlanVer13Funnel
    implements Funnel<OFActionIdPushVlanVer13> {
        private static final long serialVersionUID = 1L;

        OFActionIdPushVlanVer13Funnel() {
        }

        public void funnel(OFActionIdPushVlanVer13 message, PrimitiveSink sink) {
            sink.putShort((short)17);
            sink.putShort((short)4);
        }
    }

    static class Reader
    implements OFMessageReader<OFActionIdPushVlan> {
        Reader() {
        }

        @Override
        public OFActionIdPushVlan readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 17) {
                throw new OFParseError("Wrong type: Expected=OFActionType.PUSH_VLAN(17), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 4) {
                throw new OFParseError("Wrong length: Expected=4(4), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - returning shared instance={}", (Object)INSTANCE);
            }
            return INSTANCE;
        }
    }
}

