/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver12;

import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Set;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFPortConfig;
import org.projectfloodlight.openflow.protocol.OFPortMod;
import org.projectfloodlight.openflow.protocol.OFPortModProp;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver12.OFPortConfigSerializerVer12;
import org.projectfloodlight.openflow.types.MacAddress;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFPortModVer12
implements OFPortMod {
    private static final Logger logger = LoggerFactory.getLogger(OFPortModVer12.class);
    static final byte WIRE_VERSION = 3;
    static final int LENGTH = 40;
    private static final long DEFAULT_XID = 0L;
    private static final OFPort DEFAULT_PORT_NO = OFPort.ANY;
    private static final MacAddress DEFAULT_HW_ADDR = MacAddress.NONE;
    private static final Set<OFPortConfig> DEFAULT_CONFIG = ImmutableSet.of();
    private static final Set<OFPortConfig> DEFAULT_MASK = ImmutableSet.of();
    private static final long DEFAULT_ADVERTISE = 0L;
    private final long xid;
    private final OFPort portNo;
    private final MacAddress hwAddr;
    private final Set<OFPortConfig> config;
    private final Set<OFPortConfig> mask;
    private final long advertise;
    static final OFPortModVer12 DEFAULT = new OFPortModVer12(0L, DEFAULT_PORT_NO, DEFAULT_HW_ADDR, DEFAULT_CONFIG, DEFAULT_MASK, 0L);
    static final Reader READER = new Reader();
    static final OFPortModVer12Funnel FUNNEL = new OFPortModVer12Funnel();
    static final Writer WRITER = new Writer();

    OFPortModVer12(long xid, OFPort portNo, MacAddress hwAddr, Set<OFPortConfig> config, Set<OFPortConfig> mask, long advertise) {
        if (portNo == null) {
            throw new NullPointerException("OFPortModVer12: property portNo cannot be null");
        }
        if (hwAddr == null) {
            throw new NullPointerException("OFPortModVer12: property hwAddr cannot be null");
        }
        if (config == null) {
            throw new NullPointerException("OFPortModVer12: property config cannot be null");
        }
        if (mask == null) {
            throw new NullPointerException("OFPortModVer12: property mask cannot be null");
        }
        this.xid = U32.normalize(xid);
        this.portNo = portNo;
        this.hwAddr = hwAddr;
        this.config = config;
        this.mask = mask;
        this.advertise = U32.normalize(advertise);
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_12;
    }

    @Override
    public OFType getType() {
        return OFType.PORT_MOD;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public OFPort getPortNo() {
        return this.portNo;
    }

    @Override
    public MacAddress getHwAddr() {
        return this.hwAddr;
    }

    @Override
    public Set<OFPortConfig> getConfig() {
        return this.config;
    }

    @Override
    public Set<OFPortConfig> getMask() {
        return this.mask;
    }

    @Override
    public long getAdvertise() {
        return this.advertise;
    }

    @Override
    public List<OFPortModProp> getProperties() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property properties not supported in version 1.2");
    }

    @Override
    public OFPortMod.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFPortModVer12(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("portNo=").append(this.portNo);
        b.append(", ");
        b.append("hwAddr=").append(this.hwAddr);
        b.append(", ");
        b.append("config=").append(this.config);
        b.append(", ");
        b.append("mask=").append(this.mask);
        b.append(", ");
        b.append("advertise=").append(this.advertise);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFPortModVer12 other = (OFPortModVer12)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.portNo == null ? other.portNo != null : !this.portNo.equals(other.portNo)) {
            return false;
        }
        if (this.hwAddr == null ? other.hwAddr != null : !this.hwAddr.equals(other.hwAddr)) {
            return false;
        }
        if (this.config == null ? other.config != null : !this.config.equals(other.config)) {
            return false;
        }
        if (this.mask == null ? other.mask != null : !this.mask.equals(other.mask)) {
            return false;
        }
        return this.advertise == other.advertise;
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFPortModVer12 other = (OFPortModVer12)obj;
        if (this.portNo == null ? other.portNo != null : !this.portNo.equals(other.portNo)) {
            return false;
        }
        if (this.hwAddr == null ? other.hwAddr != null : !this.hwAddr.equals(other.hwAddr)) {
            return false;
        }
        if (this.config == null ? other.config != null : !this.config.equals(other.config)) {
            return false;
        }
        if (this.mask == null ? other.mask != null : !this.mask.equals(other.mask)) {
            return false;
        }
        return this.advertise == other.advertise;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.portNo == null ? 0 : this.portNo.hashCode());
        result = 31 * result + (this.hwAddr == null ? 0 : this.hwAddr.hashCode());
        result = 31 * result + (this.config == null ? 0 : this.config.hashCode());
        result = 31 * result + (this.mask == null ? 0 : this.mask.hashCode());
        result = 31 * (int)(this.advertise ^ this.advertise >>> 32);
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.portNo == null ? 0 : this.portNo.hashCode());
        result = 31 * result + (this.hwAddr == null ? 0 : this.hwAddr.hashCode());
        result = 31 * result + (this.config == null ? 0 : this.config.hashCode());
        result = 31 * result + (this.mask == null ? 0 : this.mask.hashCode());
        result = 31 * (int)(this.advertise ^ this.advertise >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFPortModVer12> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFPortModVer12 message) {
            bb.writeByte(3);
            bb.writeByte(16);
            bb.writeShort(40);
            bb.writeInt(U32.t(message.xid));
            message.portNo.write4Bytes(bb);
            bb.writeZero(4);
            message.hwAddr.write6Bytes(bb);
            bb.writeZero(2);
            OFPortConfigSerializerVer12.writeTo(bb, message.config);
            OFPortConfigSerializerVer12.writeTo(bb, message.mask);
            bb.writeInt(U32.t(message.advertise));
            bb.writeZero(4);
        }
    }

    static class OFPortModVer12Funnel
    implements Funnel<OFPortModVer12> {
        private static final long serialVersionUID = 1L;

        OFPortModVer12Funnel() {
        }

        public void funnel(OFPortModVer12 message, PrimitiveSink sink) {
            sink.putByte((byte)3);
            sink.putByte((byte)16);
            sink.putShort((short)40);
            sink.putLong(message.xid);
            message.portNo.putTo(sink);
            message.hwAddr.putTo(sink);
            OFPortConfigSerializerVer12.putTo(message.config, sink);
            OFPortConfigSerializerVer12.putTo(message.mask, sink);
            sink.putLong(message.advertise);
        }
    }

    static class Reader
    implements OFMessageReader<OFPortMod> {
        Reader() {
        }

        @Override
        public OFPortMod readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 3) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_12(3), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 16) {
                throw new OFParseError("Wrong type: Expected=OFType.PORT_MOD(16), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 40) {
                throw new OFParseError("Wrong length: Expected=40(40), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            OFPort portNo = OFPort.read4Bytes(bb);
            bb.skipBytes(4);
            MacAddress hwAddr = MacAddress.read6Bytes(bb);
            bb.skipBytes(2);
            Set<OFPortConfig> config = OFPortConfigSerializerVer12.readFrom(bb);
            Set<OFPortConfig> mask = OFPortConfigSerializerVer12.readFrom(bb);
            long advertise = U32.f(bb.readInt());
            bb.skipBytes(4);
            OFPortModVer12 portModVer12 = new OFPortModVer12(xid, portNo, hwAddr, config, mask, advertise);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)portModVer12);
            }
            return portModVer12;
        }
    }

    static class Builder
    implements OFPortMod.Builder {
        private boolean xidSet;
        private long xid;
        private boolean portNoSet;
        private OFPort portNo;
        private boolean hwAddrSet;
        private MacAddress hwAddr;
        private boolean configSet;
        private Set<OFPortConfig> config;
        private boolean maskSet;
        private Set<OFPortConfig> mask;
        private boolean advertiseSet;
        private long advertise;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFType getType() {
            return OFType.PORT_MOD;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFPortMod.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFPort getPortNo() {
            return this.portNo;
        }

        @Override
        public OFPortMod.Builder setPortNo(OFPort portNo) {
            this.portNo = portNo;
            this.portNoSet = true;
            return this;
        }

        @Override
        public MacAddress getHwAddr() {
            return this.hwAddr;
        }

        @Override
        public OFPortMod.Builder setHwAddr(MacAddress hwAddr) {
            this.hwAddr = hwAddr;
            this.hwAddrSet = true;
            return this;
        }

        @Override
        public Set<OFPortConfig> getConfig() {
            return this.config;
        }

        @Override
        public OFPortMod.Builder setConfig(Set<OFPortConfig> config) {
            this.config = config;
            this.configSet = true;
            return this;
        }

        @Override
        public Set<OFPortConfig> getMask() {
            return this.mask;
        }

        @Override
        public OFPortMod.Builder setMask(Set<OFPortConfig> mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public long getAdvertise() {
            return this.advertise;
        }

        @Override
        public OFPortMod.Builder setAdvertise(long advertise) {
            this.advertise = advertise;
            this.advertiseSet = true;
            return this;
        }

        @Override
        public List<OFPortModProp> getProperties() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property properties not supported in version 1.2");
        }

        @Override
        public OFPortMod.Builder setProperties(List<OFPortModProp> properties) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property properties not supported in version 1.2");
        }

        @Override
        public OFPortMod build() {
            Set<OFPortConfig> mask;
            Set<OFPortConfig> config;
            MacAddress hwAddr;
            OFPort portNo;
            long xid = this.xidSet ? this.xid : 0L;
            OFPort oFPort = portNo = this.portNoSet ? this.portNo : DEFAULT_PORT_NO;
            if (portNo == null) {
                throw new NullPointerException("Property portNo must not be null");
            }
            MacAddress macAddress = hwAddr = this.hwAddrSet ? this.hwAddr : DEFAULT_HW_ADDR;
            if (hwAddr == null) {
                throw new NullPointerException("Property hwAddr must not be null");
            }
            Set<OFPortConfig> set = config = this.configSet ? this.config : DEFAULT_CONFIG;
            if (config == null) {
                throw new NullPointerException("Property config must not be null");
            }
            Set<OFPortConfig> set2 = mask = this.maskSet ? this.mask : DEFAULT_MASK;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            long advertise = this.advertiseSet ? this.advertise : 0L;
            return new OFPortModVer12(xid, portNo, hwAddr, config, mask, advertise);
        }
    }

    static class BuilderWithParent
    implements OFPortMod.Builder {
        final OFPortModVer12 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean portNoSet;
        private OFPort portNo;
        private boolean hwAddrSet;
        private MacAddress hwAddr;
        private boolean configSet;
        private Set<OFPortConfig> config;
        private boolean maskSet;
        private Set<OFPortConfig> mask;
        private boolean advertiseSet;
        private long advertise;

        BuilderWithParent(OFPortModVer12 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFType getType() {
            return OFType.PORT_MOD;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFPortMod.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFPort getPortNo() {
            return this.portNo;
        }

        @Override
        public OFPortMod.Builder setPortNo(OFPort portNo) {
            this.portNo = portNo;
            this.portNoSet = true;
            return this;
        }

        @Override
        public MacAddress getHwAddr() {
            return this.hwAddr;
        }

        @Override
        public OFPortMod.Builder setHwAddr(MacAddress hwAddr) {
            this.hwAddr = hwAddr;
            this.hwAddrSet = true;
            return this;
        }

        @Override
        public Set<OFPortConfig> getConfig() {
            return this.config;
        }

        @Override
        public OFPortMod.Builder setConfig(Set<OFPortConfig> config) {
            this.config = config;
            this.configSet = true;
            return this;
        }

        @Override
        public Set<OFPortConfig> getMask() {
            return this.mask;
        }

        @Override
        public OFPortMod.Builder setMask(Set<OFPortConfig> mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public long getAdvertise() {
            return this.advertise;
        }

        @Override
        public OFPortMod.Builder setAdvertise(long advertise) {
            this.advertise = advertise;
            this.advertiseSet = true;
            return this;
        }

        @Override
        public List<OFPortModProp> getProperties() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property properties not supported in version 1.2");
        }

        @Override
        public OFPortMod.Builder setProperties(List<OFPortModProp> properties) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property properties not supported in version 1.2");
        }

        @Override
        public OFPortMod build() {
            Set mask;
            Set config;
            MacAddress hwAddr;
            OFPort portNo;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            OFPort oFPort = portNo = this.portNoSet ? this.portNo : this.parentMessage.portNo;
            if (portNo == null) {
                throw new NullPointerException("Property portNo must not be null");
            }
            MacAddress macAddress = hwAddr = this.hwAddrSet ? this.hwAddr : this.parentMessage.hwAddr;
            if (hwAddr == null) {
                throw new NullPointerException("Property hwAddr must not be null");
            }
            Set set = config = this.configSet ? this.config : this.parentMessage.config;
            if (config == null) {
                throw new NullPointerException("Property config must not be null");
            }
            Set set2 = mask = this.maskSet ? this.mask : this.parentMessage.mask;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            long advertise = this.advertiseSet ? this.advertise : this.parentMessage.advertise;
            return new OFPortModVer12(xid, portNo, hwAddr, config, mask, advertise);
        }
    }
}

