/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver12;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmConnTrackingNwSrc;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmConnTrackingNwSrcVer12
implements OFOxmConnTrackingNwSrc {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmConnTrackingNwSrcVer12.class);
    static final byte WIRE_VERSION = 3;
    static final int LENGTH = 8;
    private static final U32 DEFAULT_VALUE = U32.ZERO;
    private final U32 value;
    static final OFOxmConnTrackingNwSrcVer12 DEFAULT = new OFOxmConnTrackingNwSrcVer12(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmConnTrackingNwSrcVer12Funnel FUNNEL = new OFOxmConnTrackingNwSrcVer12Funnel();
    static final Writer WRITER = new Writer();

    OFOxmConnTrackingNwSrcVer12(U32 value) {
        if (value == null) {
            throw new NullPointerException("OFOxmConnTrackingNwSrcVer12: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 126980L;
    }

    @Override
    public U32 getValue() {
        return this.value;
    }

    @Override
    public MatchField<U32> getMatchField() {
        return MatchField.CONN_TRACKING_NW_SRC;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<U32> getCanonical() {
        return this;
    }

    @Override
    public U32 getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.2");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_12;
    }

    @Override
    public OFOxmConnTrackingNwSrc.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmConnTrackingNwSrcVer12(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmConnTrackingNwSrcVer12 other = (OFOxmConnTrackingNwSrcVer12)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmConnTrackingNwSrcVer12> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFOxmConnTrackingNwSrcVer12 message) {
            bb.writeInt(126980);
            bb.writeInt(message.value.getRaw());
        }
    }

    static class OFOxmConnTrackingNwSrcVer12Funnel
    implements Funnel<OFOxmConnTrackingNwSrcVer12> {
        private static final long serialVersionUID = 1L;

        OFOxmConnTrackingNwSrcVer12Funnel() {
        }

        public void funnel(OFOxmConnTrackingNwSrcVer12 message, PrimitiveSink sink) {
            sink.putInt(126980);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmConnTrackingNwSrc> {
        Reader() {
        }

        @Override
        public OFOxmConnTrackingNwSrc readFrom(ByteBuf bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != 126980) {
                throw new OFParseError("Wrong typeLen: Expected=0x1f004L(0x1f004L), got=" + typeLen);
            }
            U32 value = U32.of(bb.readInt());
            OFOxmConnTrackingNwSrcVer12 oxmConnTrackingNwSrcVer12 = new OFOxmConnTrackingNwSrcVer12(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmConnTrackingNwSrcVer12);
            }
            return oxmConnTrackingNwSrcVer12;
        }
    }

    static class Builder
    implements OFOxmConnTrackingNwSrc.Builder {
        private boolean valueSet;
        private U32 value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 126980L;
        }

        @Override
        public U32 getValue() {
            return this.value;
        }

        @Override
        public OFOxmConnTrackingNwSrc.Builder setValue(U32 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<U32> getMatchField() {
            return MatchField.CONN_TRACKING_NW_SRC;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<U32> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.2");
        }

        @Override
        public U32 getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.2");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFOxmConnTrackingNwSrc build() {
            U32 value;
            U32 u32 = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmConnTrackingNwSrcVer12(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmConnTrackingNwSrc.Builder {
        final OFOxmConnTrackingNwSrcVer12 parentMessage;
        private boolean valueSet;
        private U32 value;

        BuilderWithParent(OFOxmConnTrackingNwSrcVer12 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 126980L;
        }

        @Override
        public U32 getValue() {
            return this.value;
        }

        @Override
        public OFOxmConnTrackingNwSrc.Builder setValue(U32 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<U32> getMatchField() {
            return MatchField.CONN_TRACKING_NW_SRC;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<U32> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.2");
        }

        @Override
        public U32 getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.2");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFOxmConnTrackingNwSrc build() {
            U32 value;
            U32 u32 = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmConnTrackingNwSrcVer12(value);
        }
    }
}

