/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver12;

import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.instruction.OFInstruction;
import org.projectfloodlight.openflow.protocol.ver12.OFInstructionApplyActionsVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFInstructionClearActionsVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFInstructionExperimenterVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFInstructionGotoTableVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFInstructionWriteActionsVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFInstructionWriteMetadataVer12;

abstract class OFInstructionVer12 {
    static final byte WIRE_VERSION = 3;
    static final int MINIMUM_LENGTH = 8;
    public static final Reader READER = new Reader();

    OFInstructionVer12() {
    }

    static class Reader
    implements OFMessageReader<OFInstruction> {
        Reader() {
        }

        @Override
        public OFInstruction readFrom(ByteBuf bb) throws OFParseError {
            if (bb.readableBytes() < 8) {
                return null;
            }
            int start = bb.readerIndex();
            short type = bb.readShort();
            bb.readerIndex(start);
            switch (type) {
                case 4: {
                    return OFInstructionApplyActionsVer12.READER.readFrom(bb);
                }
                case 5: {
                    return OFInstructionClearActionsVer12.READER.readFrom(bb);
                }
                case -1: {
                    return OFInstructionExperimenterVer12.READER.readFrom(bb);
                }
                case 1: {
                    return OFInstructionGotoTableVer12.READER.readFrom(bb);
                }
                case 3: {
                    return OFInstructionWriteActionsVer12.READER.readFrom(bb);
                }
                case 2: {
                    return OFInstructionWriteMetadataVer12.READER.readFrom(bb);
                }
            }
            throw new OFParseError("Unknown value for discriminator type of class OFInstructionVer12: " + type);
        }
    }
}

