/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver12;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnBwEnableSetRequest;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnBwEnableSetRequestVer12
implements OFBsnBwEnableSetRequest {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnBwEnableSetRequestVer12.class);
    static final byte WIRE_VERSION = 3;
    static final int LENGTH = 20;
    private static final long DEFAULT_XID = 0L;
    private static final long DEFAULT_ENABLE = 0L;
    private final long xid;
    private final long enable;
    static final OFBsnBwEnableSetRequestVer12 DEFAULT = new OFBsnBwEnableSetRequestVer12(0L, 0L);
    static final Reader READER = new Reader();
    static final OFBsnBwEnableSetRequestVer12Funnel FUNNEL = new OFBsnBwEnableSetRequestVer12Funnel();
    static final Writer WRITER = new Writer();

    OFBsnBwEnableSetRequestVer12(long xid, long enable) {
        this.xid = U32.normalize(xid);
        this.enable = U32.normalize(enable);
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_12;
    }

    @Override
    public OFType getType() {
        return OFType.EXPERIMENTER;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getSubtype() {
        return 18L;
    }

    @Override
    public long getEnable() {
        return this.enable;
    }

    @Override
    public OFBsnBwEnableSetRequest.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnBwEnableSetRequestVer12(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("enable=").append(this.enable);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnBwEnableSetRequestVer12 other = (OFBsnBwEnableSetRequestVer12)obj;
        if (this.xid != other.xid) {
            return false;
        }
        return this.enable == other.enable;
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnBwEnableSetRequestVer12 other = (OFBsnBwEnableSetRequestVer12)obj;
        return this.enable == other.enable;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * (int)(this.enable ^ this.enable >>> 32);
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.enable ^ this.enable >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnBwEnableSetRequestVer12> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnBwEnableSetRequestVer12 message) {
            bb.writeByte(3);
            bb.writeByte(4);
            bb.writeShort(20);
            bb.writeInt(U32.t(message.xid));
            bb.writeInt(6035143);
            bb.writeInt(18);
            bb.writeInt(U32.t(message.enable));
        }
    }

    static class OFBsnBwEnableSetRequestVer12Funnel
    implements Funnel<OFBsnBwEnableSetRequestVer12> {
        private static final long serialVersionUID = 1L;

        OFBsnBwEnableSetRequestVer12Funnel() {
        }

        public void funnel(OFBsnBwEnableSetRequestVer12 message, PrimitiveSink sink) {
            sink.putByte((byte)3);
            sink.putByte((byte)4);
            sink.putShort((short)20);
            sink.putLong(message.xid);
            sink.putInt(6035143);
            sink.putInt(18);
            sink.putLong(message.enable);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnBwEnableSetRequest> {
        Reader() {
        }

        @Override
        public OFBsnBwEnableSetRequest readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 3) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_12(3), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 4) {
                throw new OFParseError("Wrong type: Expected=OFType.EXPERIMENTER(4), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 20) {
                throw new OFParseError("Wrong length: Expected=20(20), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            int experimenter = bb.readInt();
            if (experimenter != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            if (subtype != 18) {
                throw new OFParseError("Wrong subtype: Expected=0x12L(0x12L), got=" + subtype);
            }
            long enable = U32.f(bb.readInt());
            OFBsnBwEnableSetRequestVer12 bsnBwEnableSetRequestVer12 = new OFBsnBwEnableSetRequestVer12(xid, enable);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnBwEnableSetRequestVer12);
            }
            return bsnBwEnableSetRequestVer12;
        }
    }

    static class Builder
    implements OFBsnBwEnableSetRequest.Builder {
        private boolean xidSet;
        private long xid;
        private boolean enableSet;
        private long enable;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnBwEnableSetRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 18L;
        }

        @Override
        public long getEnable() {
            return this.enable;
        }

        @Override
        public OFBsnBwEnableSetRequest.Builder setEnable(long enable) {
            this.enable = enable;
            this.enableSet = true;
            return this;
        }

        @Override
        public OFBsnBwEnableSetRequest build() {
            long xid = this.xidSet ? this.xid : 0L;
            long enable = this.enableSet ? this.enable : 0L;
            return new OFBsnBwEnableSetRequestVer12(xid, enable);
        }
    }

    static class BuilderWithParent
    implements OFBsnBwEnableSetRequest.Builder {
        final OFBsnBwEnableSetRequestVer12 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean enableSet;
        private long enable;

        BuilderWithParent(OFBsnBwEnableSetRequestVer12 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnBwEnableSetRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 18L;
        }

        @Override
        public long getEnable() {
            return this.enable;
        }

        @Override
        public OFBsnBwEnableSetRequest.Builder setEnable(long enable) {
            this.enable = enable;
            this.enableSet = true;
            return this;
        }

        @Override
        public OFBsnBwEnableSetRequest build() {
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            long enable = this.enableSet ? this.enable : this.parentMessage.enable;
            return new OFBsnBwEnableSetRequestVer12(xid, enable);
        }
    }
}

