/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver11;

import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessage;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.ver11.OFBarrierReplyVer11;
import org.projectfloodlight.openflow.protocol.ver11.OFBarrierRequestVer11;
import org.projectfloodlight.openflow.protocol.ver11.OFEchoReplyVer11;
import org.projectfloodlight.openflow.protocol.ver11.OFEchoRequestVer11;
import org.projectfloodlight.openflow.protocol.ver11.OFErrorMsgVer11;
import org.projectfloodlight.openflow.protocol.ver11.OFExperimenterVer11;
import org.projectfloodlight.openflow.protocol.ver11.OFFeaturesReplyVer11;
import org.projectfloodlight.openflow.protocol.ver11.OFFeaturesRequestVer11;
import org.projectfloodlight.openflow.protocol.ver11.OFFlowModVer11;
import org.projectfloodlight.openflow.protocol.ver11.OFFlowRemovedVer11;
import org.projectfloodlight.openflow.protocol.ver11.OFGetConfigReplyVer11;
import org.projectfloodlight.openflow.protocol.ver11.OFGetConfigRequestVer11;
import org.projectfloodlight.openflow.protocol.ver11.OFGroupModVer11;
import org.projectfloodlight.openflow.protocol.ver11.OFHelloVer11;
import org.projectfloodlight.openflow.protocol.ver11.OFPacketInVer11;
import org.projectfloodlight.openflow.protocol.ver11.OFPacketOutVer11;
import org.projectfloodlight.openflow.protocol.ver11.OFPortModVer11;
import org.projectfloodlight.openflow.protocol.ver11.OFPortStatusVer11;
import org.projectfloodlight.openflow.protocol.ver11.OFQueueGetConfigReplyVer11;
import org.projectfloodlight.openflow.protocol.ver11.OFQueueGetConfigRequestVer11;
import org.projectfloodlight.openflow.protocol.ver11.OFSetConfigVer11;
import org.projectfloodlight.openflow.protocol.ver11.OFStatsReplyVer11;
import org.projectfloodlight.openflow.protocol.ver11.OFStatsRequestVer11;
import org.projectfloodlight.openflow.protocol.ver11.OFTableModVer11;

abstract class OFMessageVer11 {
    static final byte WIRE_VERSION = 2;
    static final int MINIMUM_LENGTH = 8;
    public static final Reader READER = new Reader();

    OFMessageVer11() {
    }

    static class Reader
    implements OFMessageReader<OFMessage> {
        Reader() {
        }

        @Override
        public OFMessage readFrom(ByteBuf bb) throws OFParseError {
            if (bb.readableBytes() < 8) {
                return null;
            }
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 2) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_11(2), got=" + version);
            }
            byte type = bb.readByte();
            bb.readerIndex(start);
            switch (type) {
                case 19: {
                    return OFStatsReplyVer11.READER.readFrom(bb);
                }
                case 18: {
                    return OFStatsRequestVer11.READER.readFrom(bb);
                }
                case 1: {
                    return OFErrorMsgVer11.READER.readFrom(bb);
                }
                case 21: {
                    return OFBarrierReplyVer11.READER.readFrom(bb);
                }
                case 20: {
                    return OFBarrierRequestVer11.READER.readFrom(bb);
                }
                case 4: {
                    return OFExperimenterVer11.READER.readFrom(bb);
                }
                case 3: {
                    return OFEchoReplyVer11.READER.readFrom(bb);
                }
                case 2: {
                    return OFEchoRequestVer11.READER.readFrom(bb);
                }
                case 6: {
                    return OFFeaturesReplyVer11.READER.readFrom(bb);
                }
                case 5: {
                    return OFFeaturesRequestVer11.READER.readFrom(bb);
                }
                case 14: {
                    return OFFlowModVer11.READER.readFrom(bb);
                }
                case 11: {
                    return OFFlowRemovedVer11.READER.readFrom(bb);
                }
                case 8: {
                    return OFGetConfigReplyVer11.READER.readFrom(bb);
                }
                case 7: {
                    return OFGetConfigRequestVer11.READER.readFrom(bb);
                }
                case 0: {
                    return OFHelloVer11.READER.readFrom(bb);
                }
                case 10: {
                    return OFPacketInVer11.READER.readFrom(bb);
                }
                case 13: {
                    return OFPacketOutVer11.READER.readFrom(bb);
                }
                case 16: {
                    return OFPortModVer11.READER.readFrom(bb);
                }
                case 12: {
                    return OFPortStatusVer11.READER.readFrom(bb);
                }
                case 23: {
                    return OFQueueGetConfigReplyVer11.READER.readFrom(bb);
                }
                case 22: {
                    return OFQueueGetConfigRequestVer11.READER.readFrom(bb);
                }
                case 9: {
                    return OFSetConfigVer11.READER.readFrom(bb);
                }
                case 17: {
                    return OFTableModVer11.READER.readFrom(bb);
                }
                case 15: {
                    return OFGroupModVer11.READER.readFrom(bb);
                }
            }
            throw new OFParseError("Unknown value for discriminator type of class OFMessageVer11: " + type);
        }
    }
}

