/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver10;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnGetL2TableReply;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.types.U8;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnGetL2TableReplyVer10
implements OFBsnGetL2TableReply {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnGetL2TableReplyVer10.class);
    static final byte WIRE_VERSION = 1;
    static final int LENGTH = 24;
    private static final long DEFAULT_XID = 0L;
    private static final short DEFAULT_L2_TABLE_ENABLE = 0;
    private static final int DEFAULT_L2_TABLE_PRIORITY = 0;
    private final long xid;
    private final short l2TableEnable;
    private final int l2TablePriority;
    static final OFBsnGetL2TableReplyVer10 DEFAULT = new OFBsnGetL2TableReplyVer10(0L, 0, 0);
    static final Reader READER = new Reader();
    static final OFBsnGetL2TableReplyVer10Funnel FUNNEL = new OFBsnGetL2TableReplyVer10Funnel();
    static final Writer WRITER = new Writer();

    OFBsnGetL2TableReplyVer10(long xid, short l2TableEnable, int l2TablePriority) {
        this.xid = U32.normalize(xid);
        this.l2TableEnable = U8.normalize(l2TableEnable);
        this.l2TablePriority = U16.normalize(l2TablePriority);
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_10;
    }

    @Override
    public OFType getType() {
        return OFType.EXPERIMENTER;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getSubtype() {
        return 14L;
    }

    @Override
    public short getL2TableEnable() {
        return this.l2TableEnable;
    }

    @Override
    public int getL2TablePriority() {
        return this.l2TablePriority;
    }

    @Override
    public OFBsnGetL2TableReply.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnGetL2TableReplyVer10(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("l2TableEnable=").append(this.l2TableEnable);
        b.append(", ");
        b.append("l2TablePriority=").append(this.l2TablePriority);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnGetL2TableReplyVer10 other = (OFBsnGetL2TableReplyVer10)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.l2TableEnable != other.l2TableEnable) {
            return false;
        }
        return this.l2TablePriority == other.l2TablePriority;
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnGetL2TableReplyVer10 other = (OFBsnGetL2TableReplyVer10)obj;
        if (this.l2TableEnable != other.l2TableEnable) {
            return false;
        }
        return this.l2TablePriority == other.l2TablePriority;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + this.l2TableEnable;
        result = 31 * result + this.l2TablePriority;
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.l2TableEnable;
        result = 31 * result + this.l2TablePriority;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnGetL2TableReplyVer10> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnGetL2TableReplyVer10 message) {
            bb.writeByte(1);
            bb.writeByte(4);
            bb.writeShort(24);
            bb.writeInt(U32.t(message.xid));
            bb.writeInt(6035143);
            bb.writeInt(14);
            bb.writeByte((int)U8.t(message.l2TableEnable));
            bb.writeZero(1);
            bb.writeShort((int)U16.t(message.l2TablePriority));
            bb.writeZero(4);
        }
    }

    static class OFBsnGetL2TableReplyVer10Funnel
    implements Funnel<OFBsnGetL2TableReplyVer10> {
        private static final long serialVersionUID = 1L;

        OFBsnGetL2TableReplyVer10Funnel() {
        }

        public void funnel(OFBsnGetL2TableReplyVer10 message, PrimitiveSink sink) {
            sink.putByte((byte)1);
            sink.putByte((byte)4);
            sink.putShort((short)24);
            sink.putLong(message.xid);
            sink.putInt(6035143);
            sink.putInt(14);
            sink.putShort(message.l2TableEnable);
            sink.putInt(message.l2TablePriority);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnGetL2TableReply> {
        Reader() {
        }

        @Override
        public OFBsnGetL2TableReply readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 1) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_10(1), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 4) {
                throw new OFParseError("Wrong type: Expected=OFType.EXPERIMENTER(4), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 24) {
                throw new OFParseError("Wrong length: Expected=24(24), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            int experimenter = bb.readInt();
            if (experimenter != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            if (subtype != 14) {
                throw new OFParseError("Wrong subtype: Expected=0xeL(0xeL), got=" + subtype);
            }
            short l2TableEnable = U8.f(bb.readByte());
            bb.skipBytes(1);
            int l2TablePriority = U16.f(bb.readShort());
            bb.skipBytes(4);
            OFBsnGetL2TableReplyVer10 bsnGetL2TableReplyVer10 = new OFBsnGetL2TableReplyVer10(xid, l2TableEnable, l2TablePriority);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnGetL2TableReplyVer10);
            }
            return bsnGetL2TableReplyVer10;
        }
    }

    static class Builder
    implements OFBsnGetL2TableReply.Builder {
        private boolean xidSet;
        private long xid;
        private boolean l2TableEnableSet;
        private short l2TableEnable;
        private boolean l2TablePrioritySet;
        private int l2TablePriority;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_10;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnGetL2TableReply.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 14L;
        }

        @Override
        public short getL2TableEnable() {
            return this.l2TableEnable;
        }

        @Override
        public OFBsnGetL2TableReply.Builder setL2TableEnable(short l2TableEnable) {
            this.l2TableEnable = l2TableEnable;
            this.l2TableEnableSet = true;
            return this;
        }

        @Override
        public int getL2TablePriority() {
            return this.l2TablePriority;
        }

        @Override
        public OFBsnGetL2TableReply.Builder setL2TablePriority(int l2TablePriority) {
            this.l2TablePriority = l2TablePriority;
            this.l2TablePrioritySet = true;
            return this;
        }

        @Override
        public OFBsnGetL2TableReply build() {
            long xid = this.xidSet ? this.xid : 0L;
            short l2TableEnable = this.l2TableEnableSet ? this.l2TableEnable : (short)0;
            int l2TablePriority = this.l2TablePrioritySet ? this.l2TablePriority : 0;
            return new OFBsnGetL2TableReplyVer10(xid, l2TableEnable, l2TablePriority);
        }
    }

    static class BuilderWithParent
    implements OFBsnGetL2TableReply.Builder {
        final OFBsnGetL2TableReplyVer10 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean l2TableEnableSet;
        private short l2TableEnable;
        private boolean l2TablePrioritySet;
        private int l2TablePriority;

        BuilderWithParent(OFBsnGetL2TableReplyVer10 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_10;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnGetL2TableReply.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 14L;
        }

        @Override
        public short getL2TableEnable() {
            return this.l2TableEnable;
        }

        @Override
        public OFBsnGetL2TableReply.Builder setL2TableEnable(short l2TableEnable) {
            this.l2TableEnable = l2TableEnable;
            this.l2TableEnableSet = true;
            return this;
        }

        @Override
        public int getL2TablePriority() {
            return this.l2TablePriority;
        }

        @Override
        public OFBsnGetL2TableReply.Builder setL2TablePriority(int l2TablePriority) {
            this.l2TablePriority = l2TablePriority;
            this.l2TablePrioritySet = true;
            return this;
        }

        @Override
        public OFBsnGetL2TableReply build() {
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            short l2TableEnable = this.l2TableEnableSet ? this.l2TableEnable : this.parentMessage.l2TableEnable;
            int l2TablePriority = this.l2TablePrioritySet ? this.l2TablePriority : this.parentMessage.l2TablePriority;
            return new OFBsnGetL2TableReplyVer10(xid, l2TableEnable, l2TablePriority);
        }
    }
}

