/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver10;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFActionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.action.OFActionStripVlan;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFActionStripVlanVer10
implements OFActionStripVlan {
    private static final Logger logger = LoggerFactory.getLogger(OFActionStripVlanVer10.class);
    static final byte WIRE_VERSION = 1;
    static final int LENGTH = 8;
    static final OFActionStripVlanVer10 DEFAULT = new OFActionStripVlanVer10();
    static final OFActionStripVlanVer10 INSTANCE = new OFActionStripVlanVer10();
    static final Reader READER = new Reader();
    static final OFActionStripVlanVer10Funnel FUNNEL = new OFActionStripVlanVer10Funnel();
    static final Writer WRITER = new Writer();

    private OFActionStripVlanVer10() {
    }

    @Override
    public OFActionType getType() {
        return OFActionType.STRIP_VLAN;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_10;
    }

    @Override
    public OFActionStripVlan.Builder createBuilder() {
        throw new UnsupportedOperationException("OFActionStripVlanVer10 has no mutable properties -- builder unneeded");
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFActionStripVlanVer10(");
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFActionStripVlanVer10> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFActionStripVlanVer10 message) {
            bb.writeShort(3);
            bb.writeShort(8);
            bb.writeZero(4);
        }
    }

    static class OFActionStripVlanVer10Funnel
    implements Funnel<OFActionStripVlanVer10> {
        private static final long serialVersionUID = 1L;

        OFActionStripVlanVer10Funnel() {
        }

        public void funnel(OFActionStripVlanVer10 message, PrimitiveSink sink) {
            sink.putShort((short)3);
            sink.putShort((short)8);
        }
    }

    static class Reader
    implements OFMessageReader<OFActionStripVlan> {
        Reader() {
        }

        @Override
        public OFActionStripVlan readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 3) {
                throw new OFParseError("Wrong type: Expected=OFActionType.STRIP_VLAN(3), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            bb.skipBytes(4);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - returning shared instance={}", (Object)INSTANCE);
            }
            return INSTANCE;
        }
    }
}

