/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFFlowLightweightStatsReply;
import org.projectfloodlight.openflow.protocol.OFFlowStatsReason;
import org.projectfloodlight.openflow.protocol.OFOxsList;
import org.projectfloodlight.openflow.protocol.OFStatsReplyFlags;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxs.OFOxs;
import org.projectfloodlight.openflow.protocol.stat.Stat;
import org.projectfloodlight.openflow.protocol.ver15.OFFactoryVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFFlowLightweightStatsReplyVer15;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.OFValueType;
import org.projectfloodlight.openflow.types.TableId;
import org.projectfloodlight.openflow.types.U64;

public class OFFlowLightweightStatsReplyVer15Test {
    OFFactory factory;
    static final byte[] FLOW_LIGHTWEIGHT_STATS_REPLY_SERIALIZED = new byte[]{6, 19, 0, 72, 18, 52, 86, 120, 0, 17, 0, 1, 0, 0, 0, 0, 0, 56, 0, 0, 1, 0, 0, 1, 0, 1, 0, 16, -128, 0, 1, 8, 0, 0, 0, 4, 0, 0, 0, 5, 0, 0, 0, 28, -128, 2, 0, 8, 0, 0, 0, 0, 0, 0, 0, 4, -128, 2, 2, 8, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0};

    @Before
    public void setup() {
        this.factory = OFFactoryVer15.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFFlowLightweightStatsReply.Builder builder = this.factory.buildFlowLightweightStatsReply();
        builder.setXid(305419896L).setFlags((Set)ImmutableSet.of((Object)OFStatsReplyFlags.REPLY_MORE)).setEntries((List)ImmutableList.of((Object)this.factory.buildFlowLightweightStatsEntry().setTableId(TableId.of((int)1)).setReason(OFFlowStatsReason.STATS_REQUEST).setPriority(1).setMatch(this.factory.buildMatch().setMasked(MatchField.IN_PORT, (OFValueType)OFPort.of((int)4), (OFValueType)OFPort.of((int)5)).build()).setStats((Stat)this.factory.buildStatV6().setOxsFields(OFOxsList.of((OFOxs[])new OFOxs[]{this.factory.oxss().buildDuration().setValue(U64.of((long)4L)).build(), this.factory.oxss().buildIdleTime().setValue(U64.of((long)6L)).build()})).build()).build())).build();
        OFFlowLightweightStatsReply flowLightweightStatsReply = builder.build();
        ByteBuf bb = Unpooled.buffer();
        flowLightweightStatsReply.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)FLOW_LIGHTWEIGHT_STATS_REPLY_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFFlowLightweightStatsReply.Builder builder = this.factory.buildFlowLightweightStatsReply();
        builder.setXid(305419896L).setFlags((Set)ImmutableSet.of((Object)OFStatsReplyFlags.REPLY_MORE)).setEntries((List)ImmutableList.of((Object)this.factory.buildFlowLightweightStatsEntry().setTableId(TableId.of((int)1)).setReason(OFFlowStatsReason.STATS_REQUEST).setPriority(1).setMatch(this.factory.buildMatch().setMasked(MatchField.IN_PORT, (OFValueType)OFPort.of((int)4), (OFValueType)OFPort.of((int)5)).build()).setStats((Stat)this.factory.buildStatV6().setOxsFields(OFOxsList.of((OFOxs[])new OFOxs[]{this.factory.oxss().buildDuration().setValue(U64.of((long)4L)).build(), this.factory.oxss().buildIdleTime().setValue(U64.of((long)6L)).build()})).build()).build())).build();
        OFFlowLightweightStatsReply flowLightweightStatsReplyBuilt = builder.build();
        ByteBuf input = Unpooled.copiedBuffer((byte[])FLOW_LIGHTWEIGHT_STATS_REPLY_SERIALIZED);
        OFFlowLightweightStatsReply flowLightweightStatsReplyRead = OFFlowLightweightStatsReplyVer15.READER.readFrom(input);
        Assert.assertEquals((long)FLOW_LIGHTWEIGHT_STATS_REPLY_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)flowLightweightStatsReplyBuilt, (Object)flowLightweightStatsReplyRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ByteBuf input = Unpooled.copiedBuffer((byte[])FLOW_LIGHTWEIGHT_STATS_REPLY_SERIALIZED);
        OFFlowLightweightStatsReply flowLightweightStatsReply = OFFlowLightweightStatsReplyVer15.READER.readFrom(input);
        Assert.assertEquals((long)FLOW_LIGHTWEIGHT_STATS_REPLY_SERIALIZED.length, (long)input.readerIndex());
        ByteBuf bb = Unpooled.buffer();
        flowLightweightStatsReply.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)FLOW_LIGHTWEIGHT_STATS_REPLY_SERIALIZED));
    }
}

