/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver12;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmIpv6Dst;
import org.projectfloodlight.openflow.protocol.oxm.OFOxms;
import org.projectfloodlight.openflow.protocol.ver12.OFOxmIpv6DstVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFOxmsVer12;

public class OFOxmIpv6DstVer12Test {
    OFOxms factory;
    static final byte[] OXM_IPV6_DST_SERIALIZED = new byte[]{-128, 0, 54, 16, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};

    @Before
    public void setup() {
        this.factory = OFOxmsVer12.INSTANCE;
    }

    @Test
    public void testReadWrite() throws Exception {
        ByteBuf input = Unpooled.copiedBuffer((byte[])OXM_IPV6_DST_SERIALIZED);
        OFOxmIpv6Dst oxmIpv6Dst = OFOxmIpv6DstVer12.READER.readFrom(input);
        Assert.assertEquals((long)OXM_IPV6_DST_SERIALIZED.length, (long)input.readerIndex());
        ByteBuf bb = Unpooled.buffer();
        oxmIpv6Dst.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)OXM_IPV6_DST_SERIALIZED));
    }
}

