// Copyright (c) 2008 The Board of Trustees of The Leland Stanford Junior University
// Copyright (c) 2011, 2012 Open Networking Foundation
// Copyright (c) 2012, 2013 Big Switch Networks, Inc.
// This library was generated by the LoxiGen Compiler.
// See the file LICENSE.txt which should have been included in the source distribution

// Automatically generated by LOXI from template of_class.java
// Do not modify

package org.projectfloodlight.openflow.protocol.ver15;

import org.projectfloodlight.openflow.protocol.*;
import org.projectfloodlight.openflow.protocol.action.*;
import org.projectfloodlight.openflow.protocol.actionid.*;
import org.projectfloodlight.openflow.protocol.bsntlv.*;
import org.projectfloodlight.openflow.protocol.errormsg.*;
import org.projectfloodlight.openflow.protocol.meterband.*;
import org.projectfloodlight.openflow.protocol.instruction.*;
import org.projectfloodlight.openflow.protocol.instructionid.*;
import org.projectfloodlight.openflow.protocol.match.*;
import org.projectfloodlight.openflow.protocol.stat.*;
import org.projectfloodlight.openflow.protocol.oxm.*;
import org.projectfloodlight.openflow.protocol.oxs.*;
import org.projectfloodlight.openflow.protocol.queueprop.*;
import org.projectfloodlight.openflow.types.*;
import org.projectfloodlight.openflow.util.*;
import org.projectfloodlight.openflow.exceptions.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.Set;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import com.google.common.collect.ImmutableList;
import io.netty.buffer.ByteBuf;
import com.google.common.hash.PrimitiveSink;
import com.google.common.hash.Funnel;

class OFControllerStatusStatsReplyVer15 implements OFControllerStatusStatsReply {
    private static final Logger logger = LoggerFactory.getLogger(OFControllerStatusStatsReplyVer15.class);
    // version: 1.5
    final static byte WIRE_VERSION = 6;
    final static int MINIMUM_LENGTH = 16;
    // maximum OF message length: 16 bit, unsigned
    final static int MAXIMUM_LENGTH = 0xFFFF;

        private final static long DEFAULT_XID = 0x0L;
        private final static Set<OFStatsReplyFlags> DEFAULT_FLAGS = ImmutableSet.<OFStatsReplyFlags>of();
        private final static List<OFControllerStatusEntry> DEFAULT_CONTROLLER_STATUS = ImmutableList.<OFControllerStatusEntry>of();

    // OF message fields
    private final long xid;
    private final Set<OFStatsReplyFlags> flags;
    private final List<OFControllerStatusEntry> controllerStatus;
//
    // Immutable default instance
    final static OFControllerStatusStatsReplyVer15 DEFAULT = new OFControllerStatusStatsReplyVer15(
        DEFAULT_XID, DEFAULT_FLAGS, DEFAULT_CONTROLLER_STATUS
    );

    // package private constructor - used by readers, builders, and factory
    OFControllerStatusStatsReplyVer15(long xid, Set<OFStatsReplyFlags> flags, List<OFControllerStatusEntry> controllerStatus) {
        if(flags == null) {
            throw new NullPointerException("OFControllerStatusStatsReplyVer15: property flags cannot be null");
        }
        if(controllerStatus == null) {
            throw new NullPointerException("OFControllerStatusStatsReplyVer15: property controllerStatus cannot be null");
        }
        this.xid = U32.normalize(xid);
        this.flags = flags;
        this.controllerStatus = controllerStatus;
    }

    // Accessors for OF message fields
    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFType getType() {
        return OFType.STATS_REPLY;
    }

    @Override
    public long getXid() {
        return xid;
    }

    @Override
    public OFStatsType getStatsType() {
        return OFStatsType.CONTROLLER_STATUS;
    }

    @Override
    public Set<OFStatsReplyFlags> getFlags() {
        return flags;
    }

    @Override
    public List<OFControllerStatusEntry> getControllerStatus() {
        return controllerStatus;
    }



    public OFControllerStatusStatsReply.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    static class BuilderWithParent implements OFControllerStatusStatsReply.Builder {
        final OFControllerStatusStatsReplyVer15 parentMessage;

        // OF message fields
        private boolean xidSet;
        private long xid;
        private boolean flagsSet;
        private Set<OFStatsReplyFlags> flags;
        private boolean controllerStatusSet;
        private List<OFControllerStatusEntry> controllerStatus;

        BuilderWithParent(OFControllerStatusStatsReplyVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFType getType() {
        return OFType.STATS_REPLY;
    }

    @Override
    public long getXid() {
        return xid;
    }

    @Override
    public OFControllerStatusStatsReply.Builder setXid(long xid) {
        this.xid = xid;
        this.xidSet = true;
        return this;
    }
    @Override
    public OFStatsType getStatsType() {
        return OFStatsType.CONTROLLER_STATUS;
    }

    @Override
    public Set<OFStatsReplyFlags> getFlags() {
        return flags;
    }

    @Override
    public OFControllerStatusStatsReply.Builder setFlags(Set<OFStatsReplyFlags> flags) {
        this.flags = flags;
        this.flagsSet = true;
        return this;
    }
    @Override
    public List<OFControllerStatusEntry> getControllerStatus() {
        return controllerStatus;
    }

    @Override
    public OFControllerStatusStatsReply.Builder setControllerStatus(List<OFControllerStatusEntry> controllerStatus) {
        this.controllerStatus = controllerStatus;
        this.controllerStatusSet = true;
        return this;
    }


        @Override
        public OFControllerStatusStatsReply build() {
                long xid = this.xidSet ? this.xid : parentMessage.xid;
                Set<OFStatsReplyFlags> flags = this.flagsSet ? this.flags : parentMessage.flags;
                if(flags == null)
                    throw new NullPointerException("Property flags must not be null");
                List<OFControllerStatusEntry> controllerStatus = this.controllerStatusSet ? this.controllerStatus : parentMessage.controllerStatus;
                if(controllerStatus == null)
                    throw new NullPointerException("Property controllerStatus must not be null");

                //
                return new OFControllerStatusStatsReplyVer15(
                    xid,
                    flags,
                    controllerStatus
                );
        }

    }

    static class Builder implements OFControllerStatusStatsReply.Builder {
        // OF message fields
        private boolean xidSet;
        private long xid;
        private boolean flagsSet;
        private Set<OFStatsReplyFlags> flags;
        private boolean controllerStatusSet;
        private List<OFControllerStatusEntry> controllerStatus;

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFType getType() {
        return OFType.STATS_REPLY;
    }

    @Override
    public long getXid() {
        return xid;
    }

    @Override
    public OFControllerStatusStatsReply.Builder setXid(long xid) {
        this.xid = xid;
        this.xidSet = true;
        return this;
    }
    @Override
    public OFStatsType getStatsType() {
        return OFStatsType.CONTROLLER_STATUS;
    }

    @Override
    public Set<OFStatsReplyFlags> getFlags() {
        return flags;
    }

    @Override
    public OFControllerStatusStatsReply.Builder setFlags(Set<OFStatsReplyFlags> flags) {
        this.flags = flags;
        this.flagsSet = true;
        return this;
    }
    @Override
    public List<OFControllerStatusEntry> getControllerStatus() {
        return controllerStatus;
    }

    @Override
    public OFControllerStatusStatsReply.Builder setControllerStatus(List<OFControllerStatusEntry> controllerStatus) {
        this.controllerStatus = controllerStatus;
        this.controllerStatusSet = true;
        return this;
    }
//
        @Override
        public OFControllerStatusStatsReply build() {
            long xid = this.xidSet ? this.xid : DEFAULT_XID;
            Set<OFStatsReplyFlags> flags = this.flagsSet ? this.flags : DEFAULT_FLAGS;
            if(flags == null)
                throw new NullPointerException("Property flags must not be null");
            List<OFControllerStatusEntry> controllerStatus = this.controllerStatusSet ? this.controllerStatus : DEFAULT_CONTROLLER_STATUS;
            if(controllerStatus == null)
                throw new NullPointerException("Property controllerStatus must not be null");


            return new OFControllerStatusStatsReplyVer15(
                    xid,
                    flags,
                    controllerStatus
                );
        }

    }


    final static Reader READER = new Reader();
    static class Reader implements OFMessageReader<OFControllerStatusStatsReply> {
        @Override
        public OFControllerStatusStatsReply readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            // fixed value property version == 6
            byte version = bb.readByte();
            if(version != (byte) 0x6)
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_15(6), got="+version);
            // fixed value property type == 19
            byte type = bb.readByte();
            if(type != (byte) 0x13)
                throw new OFParseError("Wrong type: Expected=OFType.STATS_REPLY(19), got="+type);
            int length = U16.f(bb.readShort());
            if(length < MINIMUM_LENGTH)
                throw new OFParseError("Wrong length: Expected to be >= " + MINIMUM_LENGTH + ", was: " + length);
            if(bb.readableBytes() + (bb.readerIndex() - start) < length) {
                // Buffer does not have all data yet
                bb.readerIndex(start);
                return null;
            }
            if(logger.isTraceEnabled())
                logger.trace("readFrom - length={}", length);
            long xid = U32.f(bb.readInt());
            // fixed value property statsType == 18
            short statsType = bb.readShort();
            if(statsType != (short) 0x12)
                throw new OFParseError("Wrong statsType: Expected=OFStatsType.CONTROLLER_STATUS(18), got="+statsType);
            Set<OFStatsReplyFlags> flags = OFStatsReplyFlagsSerializerVer15.readFrom(bb);
            // pad: 4 bytes
            bb.skipBytes(4);
            List<OFControllerStatusEntry> controllerStatus = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFControllerStatusEntryVer15.READER);

            OFControllerStatusStatsReplyVer15 controllerStatusStatsReplyVer15 = new OFControllerStatusStatsReplyVer15(
                    xid,
                      flags,
                      controllerStatus
                    );
            if(logger.isTraceEnabled())
                logger.trace("readFrom - read={}", controllerStatusStatsReplyVer15);
            return controllerStatusStatsReplyVer15;
        }
    }

    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    final static OFControllerStatusStatsReplyVer15Funnel FUNNEL = new OFControllerStatusStatsReplyVer15Funnel();
    static class OFControllerStatusStatsReplyVer15Funnel implements Funnel<OFControllerStatusStatsReplyVer15> {
        private static final long serialVersionUID = 1L;
        @Override
        public void funnel(OFControllerStatusStatsReplyVer15 message, PrimitiveSink sink) {
            // fixed value property version = 6
            sink.putByte((byte) 0x6);
            // fixed value property type = 19
            sink.putByte((byte) 0x13);
            // FIXME: skip funnel of length
            sink.putLong(message.xid);
            // fixed value property statsType = 18
            sink.putShort((short) 0x12);
            OFStatsReplyFlagsSerializerVer15.putTo(message.flags, sink);
            // skip pad (4 bytes)
            FunnelUtils.putList(message.controllerStatus, sink);
        }
    }


    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    final static Writer WRITER = new Writer();
    static class Writer implements OFMessageWriter<OFControllerStatusStatsReplyVer15> {
        @Override
        public void write(ByteBuf bb, OFControllerStatusStatsReplyVer15 message) {
            int startIndex = bb.writerIndex();
            // fixed value property version = 6
            bb.writeByte((byte) 0x6);
            // fixed value property type = 19
            bb.writeByte((byte) 0x13);
            // length is length of variable message, will be updated at the end
            int lengthIndex = bb.writerIndex();
            bb.writeShort(U16.t(0));

            bb.writeInt(U32.t(message.xid));
            // fixed value property statsType = 18
            bb.writeShort((short) 0x12);
            OFStatsReplyFlagsSerializerVer15.writeTo(bb, message.flags);
            // pad: 4 bytes
            bb.writeZero(4);
            ChannelUtils.writeList(bb, message.controllerStatus);

            // update length field
            int length = bb.writerIndex() - startIndex;
            if (length > MAXIMUM_LENGTH) {
                throw new IllegalArgumentException("OFControllerStatusStatsReplyVer15: message length (" + length + ") exceeds maximum (0xFFFF)");
            }
            bb.setShort(lengthIndex, length);

        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder("OFControllerStatusStatsReplyVer15(");
        b.append("xid=").append(xid);
        b.append(", ");
        b.append("flags=").append(flags);
        b.append(", ");
        b.append("controllerStatus=").append(controllerStatus);
        b.append(")");
        return b.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        OFControllerStatusStatsReplyVer15 other = (OFControllerStatusStatsReplyVer15) obj;

        if( xid != other.xid)
            return false;
        if (flags == null) {
            if (other.flags != null)
                return false;
        } else if (!flags.equals(other.flags))
            return false;
        if (controllerStatus == null) {
            if (other.controllerStatus != null)
                return false;
        } else if (!controllerStatus.equals(other.controllerStatus))
            return false;
        return true;
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        OFControllerStatusStatsReplyVer15 other = (OFControllerStatusStatsReplyVer15) obj;

        // ignore XID
        if (flags == null) {
            if (other.flags != null)
                return false;
        } else if (!flags.equals(other.flags))
            return false;
        if (controllerStatus == null) {
            if (other.controllerStatus != null)
                return false;
        } else if (!controllerStatus.equals(other.controllerStatus))
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;

        result = prime *  (int) (xid ^ (xid >>> 32));
        result = prime * result + ((flags == null) ? 0 : flags.hashCode());
        result = prime * result + ((controllerStatus == null) ? 0 : controllerStatus.hashCode());
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        final int prime = 31;
        int result = 1;

        // ignore XID
        result = prime * result + ((flags == null) ? 0 : flags.hashCode());
        result = prime * result + ((controllerStatus == null) ? 0 : controllerStatus.hashCode());
        return result;
    }

}
