/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.types;

import com.google.common.hash.PrimitiveSink;
import com.google.common.primitives.UnsignedInts;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.types.OFValueType;

public class VxlanNI
implements OFValueType<VxlanNI> {
    private static final int VALIDATION_MASK = 0xFFFFFF;
    static final int LENGTH = 4;
    private static final int ZERO_VAL = 0;
    public static final VxlanNI ZERO = new VxlanNI(0);
    private static final int NO_MASK_VAL = -1;
    public static final VxlanNI NO_MASK = new VxlanNI(-1);
    public static final VxlanNI FULL_MASK = ZERO;
    private final int vni;

    private VxlanNI(int vni) {
        this.vni = vni;
    }

    public static VxlanNI ofVni(int vni) {
        if (vni == 0) {
            return ZERO;
        }
        if ((vni & 0xFFFFFF) != vni) {
            throw new IllegalArgumentException(String.format("Illegal VNI value: %x", vni));
        }
        return new VxlanNI(vni);
    }

    public int getVni() {
        return this.vni;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VxlanNI other = (VxlanNI)obj;
        return this.vni == other.vni;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.vni;
        return result;
    }

    public String toString() {
        return String.valueOf(this.vni);
    }

    @Override
    public int getLength() {
        return 4;
    }

    public void write4Bytes(ByteBuf c) {
        c.writeInt(this.vni);
    }

    public static VxlanNI read4Bytes(ByteBuf c) throws OFParseError {
        return VxlanNI.ofVni(c.readInt());
    }

    @Override
    public VxlanNI applyMask(VxlanNI mask) {
        return VxlanNI.ofVni(this.vni & mask.vni);
    }

    @Override
    public int compareTo(VxlanNI o) {
        return UnsignedInts.compare((int)this.vni, (int)o.vni);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        sink.putInt(this.vni);
    }
}

