/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.types;

import java.util.ArrayList;
import javax.annotation.concurrent.Immutable;
import org.projectfloodlight.openflow.types.Masked;
import org.projectfloodlight.openflow.types.OFBitMask512;
import org.projectfloodlight.openflow.types.OFPort;

@Immutable
public class OFPortBitMap512
extends Masked<OFBitMask512> {
    private OFPortBitMap512(OFBitMask512 mask) {
        super(OFBitMask512.NONE, mask);
    }

    public boolean isOn(OFPort port) {
        return !((OFBitMask512)this.mask).isOn(port.getPortNumber());
    }

    public static OFPortBitMap512 ofPorts(OFPort ... ports) {
        Builder builder = new Builder();
        for (OFPort port : ports) {
            builder.set(port);
        }
        return builder.build();
    }

    public static OFPortBitMap512 of(OFBitMask512 mask) {
        return new OFPortBitMap512(mask);
    }

    public Iterable<OFPort> getOnPorts() {
        ArrayList<OFPort> ports = new ArrayList<OFPort>();
        for (int i = 0; i < 511; ++i) {
            if (((OFBitMask512)this.mask).isOn(i)) continue;
            ports.add(OFPort.of(i));
        }
        return ports;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof OFPortBitMap512)) {
            return false;
        }
        OFPortBitMap512 other = (OFPortBitMap512)obj;
        return ((OFBitMask512)other.value).equals(this.value) && ((OFBitMask512)other.mask).equals(this.mask);
    }

    @Override
    public int hashCode() {
        return 619 * ((OFBitMask512)this.mask).hashCode() + 257 * ((OFBitMask512)this.value).hashCode();
    }

    public static class Builder {
        private long raw1 = -1L;
        private long raw2 = -1L;
        private long raw3 = -1L;
        private long raw4 = -1L;
        private long raw5 = -1L;
        private long raw6 = -1L;
        private long raw7 = -1L;
        private long raw8 = -1L;

        public boolean isOn(OFPort port) {
            return !OFBitMask512.isBitOn(this.raw1, this.raw2, this.raw3, this.raw4, this.raw5, this.raw6, this.raw7, this.raw8, port.getPortNumber());
        }

        public Builder unset(OFPort port) {
            int bit = port.getPortNumber();
            if (bit < 0 || bit > 511) {
                throw new IndexOutOfBoundsException("Port number is out of bounds");
            }
            if (bit == 511) {
                throw new IndexOutOfBoundsException("The highest order bit in the bitmask is reserved.");
            }
            if (bit < 64) {
                this.raw8 |= 1L << bit;
            } else if (bit < 128) {
                this.raw7 |= 1L << bit - 64;
            } else if (bit < 192) {
                this.raw6 |= 1L << bit - 128;
            } else if (bit < 256) {
                this.raw5 |= 1L << bit - 192;
            } else if (bit < 320) {
                this.raw4 |= 1L << bit - 256;
            } else if (bit < 384) {
                this.raw3 |= 1L << bit - 320;
            } else if (bit < 448) {
                this.raw2 |= 1L << bit - 384;
            } else {
                this.raw1 |= 1L << bit - 448;
            }
            return this;
        }

        public Builder set(OFPort port) {
            int bit = port.getPortNumber();
            if (bit < 0 || bit > 511) {
                throw new IndexOutOfBoundsException("Port number is out of bounds");
            }
            if (bit == 511) {
                throw new IndexOutOfBoundsException("The highest order bit in the bitmask is reserved.");
            }
            if (bit < 64) {
                this.raw8 &= 1L << bit ^ 0xFFFFFFFFFFFFFFFFL;
            } else if (bit < 128) {
                this.raw7 &= 1L << bit - 64 ^ 0xFFFFFFFFFFFFFFFFL;
            } else if (bit < 192) {
                this.raw6 &= 1L << bit - 128 ^ 0xFFFFFFFFFFFFFFFFL;
            } else if (bit < 256) {
                this.raw5 &= 1L << bit - 192 ^ 0xFFFFFFFFFFFFFFFFL;
            } else if (bit < 320) {
                this.raw4 &= 1L << bit - 256 ^ 0xFFFFFFFFFFFFFFFFL;
            } else if (bit < 384) {
                this.raw3 &= 1L << bit - 320 ^ 0xFFFFFFFFFFFFFFFFL;
            } else if (bit < 448) {
                this.raw2 &= 1L << bit - 384 ^ 0xFFFFFFFFFFFFFFFFL;
            } else {
                this.raw1 &= 1L << bit - 448 ^ 0xFFFFFFFFFFFFFFFFL;
            }
            return this;
        }

        public OFPortBitMap512 build() {
            return new OFPortBitMap512(OFBitMask512.of(this.raw1, this.raw2, this.raw3, this.raw4, this.raw5, this.raw6, this.raw7, this.raw8));
        }
    }
}

