/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFPortDescPropType;
import org.projectfloodlight.openflow.types.U8;

public class OFPortDescPropTypeSerializerVer15 {
    public static final short ETHERNET_VAL = 0;
    public static final short OPTICAL_VAL = 1;
    public static final short PIPELINE_INPUT_VAL = 2;
    public static final short PIPELINE_OUTPUT_VAL = 3;
    public static final short RECIRCULATE_VAL = 4;
    public static final short EXPERIMENTER_VAL = -1;

    public static OFPortDescPropType readFrom(ByteBuf bb) throws OFParseError {
        try {
            return OFPortDescPropTypeSerializerVer15.ofWireValue(U8.f(bb.readByte()));
        }
        catch (IllegalArgumentException e) {
            throw new OFParseError(e);
        }
    }

    public static void writeTo(ByteBuf bb, OFPortDescPropType e) {
        bb.writeByte((int)U8.t(OFPortDescPropTypeSerializerVer15.toWireValue(e)));
    }

    public static void putTo(OFPortDescPropType e, PrimitiveSink sink) {
        sink.putShort(OFPortDescPropTypeSerializerVer15.toWireValue(e));
    }

    public static OFPortDescPropType ofWireValue(short val) {
        switch (val) {
            case 0: {
                return OFPortDescPropType.ETHERNET;
            }
            case 1: {
                return OFPortDescPropType.OPTICAL;
            }
            case 2: {
                return OFPortDescPropType.PIPELINE_INPUT;
            }
            case 3: {
                return OFPortDescPropType.PIPELINE_OUTPUT;
            }
            case 4: {
                return OFPortDescPropType.RECIRCULATE;
            }
            case -1: {
                return OFPortDescPropType.EXPERIMENTER;
            }
        }
        throw new IllegalArgumentException("Illegal wire value for type OFPortDescPropType in version 1.5: " + val);
    }

    public static short toWireValue(OFPortDescPropType e) {
        switch (e) {
            case ETHERNET: {
                return 0;
            }
            case OPTICAL: {
                return 1;
            }
            case PIPELINE_INPUT: {
                return 2;
            }
            case PIPELINE_OUTPUT: {
                return 3;
            }
            case RECIRCULATE: {
                return 4;
            }
            case EXPERIMENTER: {
                return -1;
            }
        }
        throw new IllegalArgumentException("Illegal enum value for type OFPortDescPropType in version 1.5: " + (Object)((Object)e));
    }
}

