/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmBsnL2CacheHit;
import org.projectfloodlight.openflow.types.OFBooleanValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmBsnL2CacheHitVer15
implements OFOxmBsnL2CacheHit {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmBsnL2CacheHitVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 5;
    private static final OFBooleanValue DEFAULT_VALUE = OFBooleanValue.FALSE;
    private final OFBooleanValue value;
    static final OFOxmBsnL2CacheHitVer15 DEFAULT = new OFOxmBsnL2CacheHitVer15(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmBsnL2CacheHitVer15Funnel FUNNEL = new OFOxmBsnL2CacheHitVer15Funnel();
    static final Writer WRITER = new Writer();

    OFOxmBsnL2CacheHitVer15(OFBooleanValue value) {
        if (value == null) {
            throw new NullPointerException("OFOxmBsnL2CacheHitVer15: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 205825L;
    }

    @Override
    public OFBooleanValue getValue() {
        return this.value;
    }

    @Override
    public MatchField<OFBooleanValue> getMatchField() {
        return MatchField.BSN_L2_CACHE_HIT;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<OFBooleanValue> getCanonical() {
        return this;
    }

    @Override
    public OFBooleanValue getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.5");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFOxmBsnL2CacheHit.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmBsnL2CacheHitVer15(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmBsnL2CacheHitVer15 other = (OFOxmBsnL2CacheHitVer15)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmBsnL2CacheHitVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFOxmBsnL2CacheHitVer15 message) {
            bb.writeInt(205825);
            bb.writeByte(message.value.getInt());
        }
    }

    static class OFOxmBsnL2CacheHitVer15Funnel
    implements Funnel<OFOxmBsnL2CacheHitVer15> {
        private static final long serialVersionUID = 1L;

        OFOxmBsnL2CacheHitVer15Funnel() {
        }

        public void funnel(OFOxmBsnL2CacheHitVer15 message, PrimitiveSink sink) {
            sink.putInt(205825);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmBsnL2CacheHit> {
        Reader() {
        }

        @Override
        public OFOxmBsnL2CacheHit readFrom(ByteBuf bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != 205825) {
                throw new OFParseError("Wrong typeLen: Expected=0x32401L(0x32401L), got=" + typeLen);
            }
            OFBooleanValue value = OFBooleanValue.of(bb.readByte() != 0);
            OFOxmBsnL2CacheHitVer15 oxmBsnL2CacheHitVer15 = new OFOxmBsnL2CacheHitVer15(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmBsnL2CacheHitVer15);
            }
            return oxmBsnL2CacheHitVer15;
        }
    }

    static class Builder
    implements OFOxmBsnL2CacheHit.Builder {
        private boolean valueSet;
        private OFBooleanValue value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 205825L;
        }

        @Override
        public OFBooleanValue getValue() {
            return this.value;
        }

        @Override
        public OFOxmBsnL2CacheHit.Builder setValue(OFBooleanValue value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<OFBooleanValue> getMatchField() {
            return MatchField.BSN_L2_CACHE_HIT;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<OFBooleanValue> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.5");
        }

        @Override
        public OFBooleanValue getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.5");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFOxmBsnL2CacheHit build() {
            OFBooleanValue value;
            OFBooleanValue oFBooleanValue = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmBsnL2CacheHitVer15(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmBsnL2CacheHit.Builder {
        final OFOxmBsnL2CacheHitVer15 parentMessage;
        private boolean valueSet;
        private OFBooleanValue value;

        BuilderWithParent(OFOxmBsnL2CacheHitVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 205825L;
        }

        @Override
        public OFBooleanValue getValue() {
            return this.value;
        }

        @Override
        public OFOxmBsnL2CacheHit.Builder setValue(OFBooleanValue value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<OFBooleanValue> getMatchField() {
            return MatchField.BSN_L2_CACHE_HIT;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<OFBooleanValue> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.5");
        }

        @Override
        public OFBooleanValue getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.5");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFOxmBsnL2CacheHit build() {
            OFBooleanValue value;
            OFBooleanValue oFBooleanValue = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmBsnL2CacheHitVer15(value);
        }
    }
}

