/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmArpTpa;
import org.projectfloodlight.openflow.types.IPv4Address;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmArpTpaVer15
implements OFOxmArpTpa {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmArpTpaVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 8;
    private static final IPv4Address DEFAULT_VALUE = IPv4Address.NONE;
    private final IPv4Address value;
    static final OFOxmArpTpaVer15 DEFAULT = new OFOxmArpTpaVer15(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmArpTpaVer15Funnel FUNNEL = new OFOxmArpTpaVer15Funnel();
    static final Writer WRITER = new Writer();

    OFOxmArpTpaVer15(IPv4Address value) {
        if (value == null) {
            throw new NullPointerException("OFOxmArpTpaVer15: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 2147495428L;
    }

    @Override
    public IPv4Address getValue() {
        return this.value;
    }

    @Override
    public MatchField<IPv4Address> getMatchField() {
        return MatchField.ARP_TPA;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<IPv4Address> getCanonical() {
        return this;
    }

    @Override
    public IPv4Address getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.5");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFOxmArpTpa.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmArpTpaVer15(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmArpTpaVer15 other = (OFOxmArpTpaVer15)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmArpTpaVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFOxmArpTpaVer15 message) {
            bb.writeInt(-2147471868);
            message.value.write4Bytes(bb);
        }
    }

    static class OFOxmArpTpaVer15Funnel
    implements Funnel<OFOxmArpTpaVer15> {
        private static final long serialVersionUID = 1L;

        OFOxmArpTpaVer15Funnel() {
        }

        public void funnel(OFOxmArpTpaVer15 message, PrimitiveSink sink) {
            sink.putInt(-2147471868);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmArpTpa> {
        Reader() {
        }

        @Override
        public OFOxmArpTpa readFrom(ByteBuf bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != -2147471868) {
                throw new OFParseError("Wrong typeLen: Expected=0x80002e04L(0x80002e04L), got=" + typeLen);
            }
            IPv4Address value = IPv4Address.read4Bytes(bb);
            OFOxmArpTpaVer15 oxmArpTpaVer15 = new OFOxmArpTpaVer15(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmArpTpaVer15);
            }
            return oxmArpTpaVer15;
        }
    }

    static class Builder
    implements OFOxmArpTpa.Builder {
        private boolean valueSet;
        private IPv4Address value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 2147495428L;
        }

        @Override
        public IPv4Address getValue() {
            return this.value;
        }

        @Override
        public OFOxmArpTpa.Builder setValue(IPv4Address value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<IPv4Address> getMatchField() {
            return MatchField.ARP_TPA;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<IPv4Address> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.5");
        }

        @Override
        public IPv4Address getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.5");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFOxmArpTpa build() {
            IPv4Address value;
            IPv4Address iPv4Address = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmArpTpaVer15(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmArpTpa.Builder {
        final OFOxmArpTpaVer15 parentMessage;
        private boolean valueSet;
        private IPv4Address value;

        BuilderWithParent(OFOxmArpTpaVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 2147495428L;
        }

        @Override
        public IPv4Address getValue() {
            return this.value;
        }

        @Override
        public OFOxmArpTpa.Builder setValue(IPv4Address value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<IPv4Address> getMatchField() {
            return MatchField.ARP_TPA;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<IPv4Address> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.5");
        }

        @Override
        public IPv4Address getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.5");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFOxmArpTpa build() {
            IPv4Address value;
            IPv4Address iPv4Address = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmArpTpaVer15(value);
        }
    }
}

