/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmActsetOutput;
import org.projectfloodlight.openflow.types.OFPort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmActsetOutputVer15
implements OFOxmActsetOutput {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmActsetOutputVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 5;
    private static final OFPort DEFAULT_VALUE = OFPort.ANY;
    private final OFPort value;
    static final OFOxmActsetOutputVer15 DEFAULT = new OFOxmActsetOutputVer15(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmActsetOutputVer15Funnel FUNNEL = new OFOxmActsetOutputVer15Funnel();
    static final Writer WRITER = new Writer();

    OFOxmActsetOutputVer15(OFPort value) {
        if (value == null) {
            throw new NullPointerException("OFOxmActsetOutputVer15: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 2147505668L;
    }

    @Override
    public OFPort getValue() {
        return this.value;
    }

    @Override
    public MatchField<OFPort> getMatchField() {
        return MatchField.ACTSET_OUTPUT;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<OFPort> getCanonical() {
        return this;
    }

    @Override
    public OFPort getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.5");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFOxmActsetOutput.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmActsetOutputVer15(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmActsetOutputVer15 other = (OFOxmActsetOutputVer15)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmActsetOutputVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFOxmActsetOutputVer15 message) {
            bb.writeInt(-2147461628);
            message.value.write4Bytes(bb);
        }
    }

    static class OFOxmActsetOutputVer15Funnel
    implements Funnel<OFOxmActsetOutputVer15> {
        private static final long serialVersionUID = 1L;

        OFOxmActsetOutputVer15Funnel() {
        }

        public void funnel(OFOxmActsetOutputVer15 message, PrimitiveSink sink) {
            sink.putInt(-2147461628);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmActsetOutput> {
        Reader() {
        }

        @Override
        public OFOxmActsetOutput readFrom(ByteBuf bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != -2147461628) {
                throw new OFParseError("Wrong typeLen: Expected=0x80005604L(0x80005604L), got=" + typeLen);
            }
            OFPort value = OFPort.read4Bytes(bb);
            OFOxmActsetOutputVer15 oxmActsetOutputVer15 = new OFOxmActsetOutputVer15(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmActsetOutputVer15);
            }
            return oxmActsetOutputVer15;
        }
    }

    static class Builder
    implements OFOxmActsetOutput.Builder {
        private boolean valueSet;
        private OFPort value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 2147505668L;
        }

        @Override
        public OFPort getValue() {
            return this.value;
        }

        @Override
        public OFOxmActsetOutput.Builder setValue(OFPort value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<OFPort> getMatchField() {
            return MatchField.ACTSET_OUTPUT;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<OFPort> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.5");
        }

        @Override
        public OFPort getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.5");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFOxmActsetOutput build() {
            OFPort value;
            OFPort oFPort = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmActsetOutputVer15(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmActsetOutput.Builder {
        final OFOxmActsetOutputVer15 parentMessage;
        private boolean valueSet;
        private OFPort value;

        BuilderWithParent(OFOxmActsetOutputVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 2147505668L;
        }

        @Override
        public OFPort getValue() {
            return this.value;
        }

        @Override
        public OFOxmActsetOutput.Builder setValue(OFPort value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<OFPort> getMatchField() {
            return MatchField.ACTSET_OUTPUT;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<OFPort> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.5");
        }

        @Override
        public OFPort getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.5");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFOxmActsetOutput build() {
            OFPort value;
            OFPort oFPort = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmActsetOutputVer15(value);
        }
    }
}

