/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.instruction.OFInstructionBsn;
import org.projectfloodlight.openflow.protocol.ver15.OFInstructionBsnArpOffloadVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFInstructionBsnAutoNegotiationVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFInstructionBsnDenyVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFInstructionBsnDhcpOffloadVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFInstructionBsnDirectedBroadcastVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFInstructionBsnDisableL3Ver15;
import org.projectfloodlight.openflow.protocol.ver15.OFInstructionBsnDisableSrcMacCheckVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFInstructionBsnDisableVlanCountersVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFInstructionBsnHashSelectVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFInstructionBsnInternalPriorityVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFInstructionBsnNdpOffloadVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFInstructionBsnPacketOfDeathVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFInstructionBsnPermitVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFInstructionBsnPrioritizePdusVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFInstructionBsnRequireVlanXlateVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFInstructionBsnSpanDestinationVer15;
import org.projectfloodlight.openflow.types.U16;

abstract class OFInstructionBsnVer15 {
    static final byte WIRE_VERSION = 6;
    static final int MINIMUM_LENGTH = 16;
    public static final Reader READER = new Reader();

    OFInstructionBsnVer15() {
    }

    static class Reader
    implements OFMessageReader<OFInstructionBsn> {
        Reader() {
        }

        @Override
        public OFInstructionBsn readFrom(ByteBuf bb) throws OFParseError {
            if (bb.readableBytes() < 16) {
                return null;
            }
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != -1) {
                throw new OFParseError("Wrong type: Expected=OFInstructionType.EXPERIMENTER(65535), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 16) {
                throw new OFParseError("Wrong length: Expected to be >= 16, was: " + length);
            }
            int experimenter = bb.readInt();
            if (experimenter != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            bb.readerIndex(start);
            switch (subtype) {
                case 1: {
                    return OFInstructionBsnArpOffloadVer15.READER.readFrom(bb);
                }
                case 11: {
                    return OFInstructionBsnAutoNegotiationVer15.READER.readFrom(bb);
                }
                case 5: {
                    return OFInstructionBsnDenyVer15.READER.readFrom(bb);
                }
                case 2: {
                    return OFInstructionBsnDhcpOffloadVer15.READER.readFrom(bb);
                }
                case 16: {
                    return OFInstructionBsnDirectedBroadcastVer15.READER.readFrom(bb);
                }
                case 13: {
                    return OFInstructionBsnDisableL3Ver15.READER.readFrom(bb);
                }
                case 0: {
                    return OFInstructionBsnDisableSrcMacCheckVer15.READER.readFrom(bb);
                }
                case 9: {
                    return OFInstructionBsnDisableVlanCountersVer15.READER.readFrom(bb);
                }
                case 15: {
                    return OFInstructionBsnHashSelectVer15.READER.readFrom(bb);
                }
                case 12: {
                    return OFInstructionBsnInternalPriorityVer15.READER.readFrom(bb);
                }
                case 14: {
                    return OFInstructionBsnNdpOffloadVer15.READER.readFrom(bb);
                }
                case 6: {
                    return OFInstructionBsnPacketOfDeathVer15.READER.readFrom(bb);
                }
                case 4: {
                    return OFInstructionBsnPermitVer15.READER.readFrom(bb);
                }
                case 7: {
                    return OFInstructionBsnPrioritizePdusVer15.READER.readFrom(bb);
                }
                case 8: {
                    return OFInstructionBsnRequireVlanXlateVer15.READER.readFrom(bb);
                }
                case 10: {
                    return OFInstructionBsnSpanDestinationVer15.READER.readFrom(bb);
                }
            }
            throw new OFParseError("Unknown value for discriminator subtype of class OFInstructionBsnVer15: " + subtype);
        }
    }
}

