/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.List;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFHello;
import org.projectfloodlight.openflow.protocol.OFHelloElem;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver15.OFHelloElemVer15;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFHelloVer15
implements OFHello {
    private static final Logger logger = LoggerFactory.getLogger(OFHelloVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int MINIMUM_LENGTH = 8;
    static final int MAXIMUM_LENGTH = 65535;
    private static final long DEFAULT_XID = 0L;
    private static final List<OFHelloElem> DEFAULT_ELEMENTS = ImmutableList.of();
    private final long xid;
    private final List<OFHelloElem> elements;
    static final OFHelloVer15 DEFAULT = new OFHelloVer15(0L, DEFAULT_ELEMENTS);
    static final Reader READER = new Reader();
    static final OFHelloVer15Funnel FUNNEL = new OFHelloVer15Funnel();
    static final Writer WRITER = new Writer();

    OFHelloVer15(long xid, List<OFHelloElem> elements) {
        if (elements == null) {
            throw new NullPointerException("OFHelloVer15: property elements cannot be null");
        }
        this.xid = U32.normalize(xid);
        this.elements = elements;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFType getType() {
        return OFType.HELLO;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public List<OFHelloElem> getElements() {
        return this.elements;
    }

    @Override
    public OFHello.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFHelloVer15(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("elements=").append(this.elements);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFHelloVer15 other = (OFHelloVer15)obj;
        if (this.xid != other.xid) {
            return false;
        }
        return !(this.elements == null ? other.elements != null : !this.elements.equals(other.elements));
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFHelloVer15 other = (OFHelloVer15)obj;
        return !(this.elements == null ? other.elements != null : !this.elements.equals(other.elements));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.elements == null ? 0 : this.elements.hashCode());
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.elements == null ? 0 : this.elements.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFHelloVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFHelloVer15 message) {
            int startIndex = bb.writerIndex();
            bb.writeByte(6);
            bb.writeByte(0);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeInt(U32.t(message.xid));
            ChannelUtils.writeList(bb, message.elements);
            int length = bb.writerIndex() - startIndex;
            if (length > 65535) {
                throw new IllegalArgumentException("OFHelloVer15: message length (" + length + ") exceeds maximum (0xFFFF)");
            }
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFHelloVer15Funnel
    implements Funnel<OFHelloVer15> {
        private static final long serialVersionUID = 1L;

        OFHelloVer15Funnel() {
        }

        public void funnel(OFHelloVer15 message, PrimitiveSink sink) {
            sink.putByte((byte)6);
            sink.putByte((byte)0);
            sink.putLong(message.xid);
            FunnelUtils.putList(message.elements, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFHello> {
        Reader() {
        }

        @Override
        public OFHello readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 6) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_15(6), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 0) {
                throw new OFParseError("Wrong type: Expected=OFType.HELLO(0), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 8) {
                throw new OFParseError("Wrong length: Expected to be >= 8, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            List<OFHelloElem> elements = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFHelloElemVer15.READER);
            OFHelloVer15 helloVer15 = new OFHelloVer15(xid, elements);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)helloVer15);
            }
            return helloVer15;
        }
    }

    static class Builder
    implements OFHello.Builder {
        private boolean xidSet;
        private long xid;
        private boolean elementsSet;
        private List<OFHelloElem> elements;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFType getType() {
            return OFType.HELLO;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFHello.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public List<OFHelloElem> getElements() {
            return this.elements;
        }

        @Override
        public OFHello.Builder setElements(List<OFHelloElem> elements) {
            this.elements = elements;
            this.elementsSet = true;
            return this;
        }

        @Override
        public OFHello build() {
            List<OFHelloElem> elements;
            long xid = this.xidSet ? this.xid : 0L;
            List<OFHelloElem> list = elements = this.elementsSet ? this.elements : DEFAULT_ELEMENTS;
            if (elements == null) {
                throw new NullPointerException("Property elements must not be null");
            }
            return new OFHelloVer15(xid, elements);
        }
    }

    static class BuilderWithParent
    implements OFHello.Builder {
        final OFHelloVer15 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean elementsSet;
        private List<OFHelloElem> elements;

        BuilderWithParent(OFHelloVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFType getType() {
            return OFType.HELLO;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFHello.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public List<OFHelloElem> getElements() {
            return this.elements;
        }

        @Override
        public OFHello.Builder setElements(List<OFHelloElem> elements) {
            this.elements = elements;
            this.elementsSet = true;
            return this;
        }

        @Override
        public OFHello build() {
            List elements;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            List list = elements = this.elementsSet ? this.elements : this.parentMessage.elements;
            if (elements == null) {
                throw new NullPointerException("Property elements must not be null");
            }
            return new OFHelloVer15(xid, elements);
        }
    }
}

