/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFFlowRemoved;
import org.projectfloodlight.openflow.protocol.OFFlowRemovedReason;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.Match;
import org.projectfloodlight.openflow.protocol.stat.Stat;
import org.projectfloodlight.openflow.protocol.ver15.ChannelUtilsVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFFactoryVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFFlowRemovedReasonSerializerVer15;
import org.projectfloodlight.openflow.types.TableId;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.types.U64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFFlowRemovedVer15
implements OFFlowRemoved {
    private static final Logger logger = LoggerFactory.getLogger(OFFlowRemovedVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int MINIMUM_LENGTH = 40;
    static final int MAXIMUM_LENGTH = 65535;
    private static final long DEFAULT_XID = 0L;
    private static final TableId DEFAULT_TABLE_ID = TableId.ALL;
    private static final int DEFAULT_PRIORITY = 0;
    private static final int DEFAULT_IDLE_TIMEOUT = 0;
    private static final int DEFAULT_HARD_TIMEOUT = 0;
    private static final U64 DEFAULT_COOKIE = U64.ZERO;
    private static final Match DEFAULT_MATCH = OFFactoryVer15.MATCH_WILDCARD_ALL;
    private final long xid;
    private final TableId tableId;
    private final OFFlowRemovedReason reason;
    private final int priority;
    private final int idleTimeout;
    private final int hardTimeout;
    private final U64 cookie;
    private final Match match;
    private final Stat stats;
    static final Reader READER = new Reader();
    static final OFFlowRemovedVer15Funnel FUNNEL = new OFFlowRemovedVer15Funnel();
    static final Writer WRITER = new Writer();

    OFFlowRemovedVer15(long xid, TableId tableId, OFFlowRemovedReason reason, int priority, int idleTimeout, int hardTimeout, U64 cookie, Match match, Stat stats) {
        if (tableId == null) {
            throw new NullPointerException("OFFlowRemovedVer15: property tableId cannot be null");
        }
        if (reason == null) {
            throw new NullPointerException("OFFlowRemovedVer15: property reason cannot be null");
        }
        if (cookie == null) {
            throw new NullPointerException("OFFlowRemovedVer15: property cookie cannot be null");
        }
        if (match == null) {
            throw new NullPointerException("OFFlowRemovedVer15: property match cannot be null");
        }
        if (stats == null) {
            throw new NullPointerException("OFFlowRemovedVer15: property stats cannot be null");
        }
        this.xid = U32.normalize(xid);
        this.tableId = tableId;
        this.reason = reason;
        this.priority = U16.normalize(priority);
        this.idleTimeout = U16.normalize(idleTimeout);
        this.hardTimeout = U16.normalize(hardTimeout);
        this.cookie = cookie;
        this.match = match;
        this.stats = stats;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFType getType() {
        return OFType.FLOW_REMOVED;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public Match getMatch() {
        return this.match;
    }

    @Override
    public U64 getCookie() {
        return this.cookie;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public OFFlowRemovedReason getReason() {
        return this.reason;
    }

    @Override
    public long getDurationSec() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property durationSec not supported in version 1.5");
    }

    @Override
    public long getDurationNsec() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property durationNsec not supported in version 1.5");
    }

    @Override
    public int getIdleTimeout() {
        return this.idleTimeout;
    }

    @Override
    public U64 getPacketCount() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property packetCount not supported in version 1.5");
    }

    @Override
    public U64 getByteCount() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property byteCount not supported in version 1.5");
    }

    @Override
    public TableId getTableId() {
        return this.tableId;
    }

    @Override
    public int getHardTimeout() {
        return this.hardTimeout;
    }

    @Override
    public Stat getStats() {
        return this.stats;
    }

    @Override
    public OFFlowRemoved.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFFlowRemovedVer15(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("tableId=").append(this.tableId);
        b.append(", ");
        b.append("reason=").append((Object)this.reason);
        b.append(", ");
        b.append("priority=").append(this.priority);
        b.append(", ");
        b.append("idleTimeout=").append(this.idleTimeout);
        b.append(", ");
        b.append("hardTimeout=").append(this.hardTimeout);
        b.append(", ");
        b.append("cookie=").append(this.cookie);
        b.append(", ");
        b.append("match=").append(this.match);
        b.append(", ");
        b.append("stats=").append(this.stats);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFFlowRemovedVer15 other = (OFFlowRemovedVer15)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.tableId == null ? other.tableId != null : !this.tableId.equals(other.tableId)) {
            return false;
        }
        if (this.reason == null ? other.reason != null : !this.reason.equals((Object)other.reason)) {
            return false;
        }
        if (this.priority != other.priority) {
            return false;
        }
        if (this.idleTimeout != other.idleTimeout) {
            return false;
        }
        if (this.hardTimeout != other.hardTimeout) {
            return false;
        }
        if (this.cookie == null ? other.cookie != null : !this.cookie.equals(other.cookie)) {
            return false;
        }
        if (this.match == null ? other.match != null : !this.match.equals(other.match)) {
            return false;
        }
        return !(this.stats == null ? other.stats != null : !this.stats.equals(other.stats));
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFFlowRemovedVer15 other = (OFFlowRemovedVer15)obj;
        if (this.tableId == null ? other.tableId != null : !this.tableId.equals(other.tableId)) {
            return false;
        }
        if (this.reason == null ? other.reason != null : !this.reason.equals((Object)other.reason)) {
            return false;
        }
        if (this.priority != other.priority) {
            return false;
        }
        if (this.idleTimeout != other.idleTimeout) {
            return false;
        }
        if (this.hardTimeout != other.hardTimeout) {
            return false;
        }
        if (this.cookie == null ? other.cookie != null : !this.cookie.equals(other.cookie)) {
            return false;
        }
        if (this.match == null ? other.match != null : !this.match.equals(other.match)) {
            return false;
        }
        return !(this.stats == null ? other.stats != null : !this.stats.equals(other.stats));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.tableId == null ? 0 : this.tableId.hashCode());
        result = 31 * result + (this.reason == null ? 0 : this.reason.hashCode());
        result = 31 * result + this.priority;
        result = 31 * result + this.idleTimeout;
        result = 31 * result + this.hardTimeout;
        result = 31 * result + (this.cookie == null ? 0 : this.cookie.hashCode());
        result = 31 * result + (this.match == null ? 0 : this.match.hashCode());
        result = 31 * result + (this.stats == null ? 0 : this.stats.hashCode());
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.tableId == null ? 0 : this.tableId.hashCode());
        result = 31 * result + (this.reason == null ? 0 : this.reason.hashCode());
        result = 31 * result + this.priority;
        result = 31 * result + this.idleTimeout;
        result = 31 * result + this.hardTimeout;
        result = 31 * result + (this.cookie == null ? 0 : this.cookie.hashCode());
        result = 31 * result + (this.match == null ? 0 : this.match.hashCode());
        result = 31 * result + (this.stats == null ? 0 : this.stats.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFFlowRemovedVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFFlowRemovedVer15 message) {
            int startIndex = bb.writerIndex();
            bb.writeByte(6);
            bb.writeByte(11);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeInt(U32.t(message.xid));
            message.tableId.writeByte(bb);
            OFFlowRemovedReasonSerializerVer15.writeTo(bb, message.reason);
            bb.writeShort((int)U16.t(message.priority));
            bb.writeShort((int)U16.t(message.idleTimeout));
            bb.writeShort((int)U16.t(message.hardTimeout));
            bb.writeLong(message.cookie.getValue());
            message.match.writeTo(bb);
            message.stats.writeTo(bb);
            int length = bb.writerIndex() - startIndex;
            if (length > 65535) {
                throw new IllegalArgumentException("OFFlowRemovedVer15: message length (" + length + ") exceeds maximum (0xFFFF)");
            }
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFFlowRemovedVer15Funnel
    implements Funnel<OFFlowRemovedVer15> {
        private static final long serialVersionUID = 1L;

        OFFlowRemovedVer15Funnel() {
        }

        public void funnel(OFFlowRemovedVer15 message, PrimitiveSink sink) {
            sink.putByte((byte)6);
            sink.putByte((byte)11);
            sink.putLong(message.xid);
            message.tableId.putTo(sink);
            OFFlowRemovedReasonSerializerVer15.putTo(message.reason, sink);
            sink.putInt(message.priority);
            sink.putInt(message.idleTimeout);
            sink.putInt(message.hardTimeout);
            message.cookie.putTo(sink);
            message.match.putTo(sink);
            message.stats.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFFlowRemoved> {
        Reader() {
        }

        @Override
        public OFFlowRemoved readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 6) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_15(6), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 11) {
                throw new OFParseError("Wrong type: Expected=OFType.FLOW_REMOVED(11), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 40) {
                throw new OFParseError("Wrong length: Expected to be >= 40, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            TableId tableId = TableId.readByte(bb);
            OFFlowRemovedReason reason = OFFlowRemovedReasonSerializerVer15.readFrom(bb);
            int priority = U16.f(bb.readShort());
            int idleTimeout = U16.f(bb.readShort());
            int hardTimeout = U16.f(bb.readShort());
            U64 cookie = U64.ofRaw(bb.readLong());
            Match match = ChannelUtilsVer15.readOFMatch(bb);
            Stat stats = ChannelUtilsVer15.readOFStat(bb);
            OFFlowRemovedVer15 flowRemovedVer15 = new OFFlowRemovedVer15(xid, tableId, reason, priority, idleTimeout, hardTimeout, cookie, match, stats);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)flowRemovedVer15);
            }
            return flowRemovedVer15;
        }
    }

    static class Builder
    implements OFFlowRemoved.Builder {
        private boolean xidSet;
        private long xid;
        private boolean tableIdSet;
        private TableId tableId;
        private boolean reasonSet;
        private OFFlowRemovedReason reason;
        private boolean prioritySet;
        private int priority;
        private boolean idleTimeoutSet;
        private int idleTimeout;
        private boolean hardTimeoutSet;
        private int hardTimeout;
        private boolean cookieSet;
        private U64 cookie;
        private boolean matchSet;
        private Match match;
        private boolean statsSet;
        private Stat stats;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFType getType() {
            return OFType.FLOW_REMOVED;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFFlowRemoved.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public Match getMatch() {
            return this.match;
        }

        @Override
        public OFFlowRemoved.Builder setMatch(Match match) {
            this.match = match;
            this.matchSet = true;
            return this;
        }

        @Override
        public U64 getCookie() {
            return this.cookie;
        }

        @Override
        public OFFlowRemoved.Builder setCookie(U64 cookie) {
            this.cookie = cookie;
            this.cookieSet = true;
            return this;
        }

        @Override
        public int getPriority() {
            return this.priority;
        }

        @Override
        public OFFlowRemoved.Builder setPriority(int priority) {
            this.priority = priority;
            this.prioritySet = true;
            return this;
        }

        @Override
        public OFFlowRemovedReason getReason() {
            return this.reason;
        }

        @Override
        public OFFlowRemoved.Builder setReason(OFFlowRemovedReason reason) {
            this.reason = reason;
            this.reasonSet = true;
            return this;
        }

        @Override
        public long getDurationSec() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property durationSec not supported in version 1.5");
        }

        @Override
        public OFFlowRemoved.Builder setDurationSec(long durationSec) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property durationSec not supported in version 1.5");
        }

        @Override
        public long getDurationNsec() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property durationNsec not supported in version 1.5");
        }

        @Override
        public OFFlowRemoved.Builder setDurationNsec(long durationNsec) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property durationNsec not supported in version 1.5");
        }

        @Override
        public int getIdleTimeout() {
            return this.idleTimeout;
        }

        @Override
        public OFFlowRemoved.Builder setIdleTimeout(int idleTimeout) {
            this.idleTimeout = idleTimeout;
            this.idleTimeoutSet = true;
            return this;
        }

        @Override
        public U64 getPacketCount() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property packetCount not supported in version 1.5");
        }

        @Override
        public OFFlowRemoved.Builder setPacketCount(U64 packetCount) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property packetCount not supported in version 1.5");
        }

        @Override
        public U64 getByteCount() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property byteCount not supported in version 1.5");
        }

        @Override
        public OFFlowRemoved.Builder setByteCount(U64 byteCount) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property byteCount not supported in version 1.5");
        }

        @Override
        public TableId getTableId() {
            return this.tableId;
        }

        @Override
        public OFFlowRemoved.Builder setTableId(TableId tableId) {
            this.tableId = tableId;
            this.tableIdSet = true;
            return this;
        }

        @Override
        public int getHardTimeout() {
            return this.hardTimeout;
        }

        @Override
        public OFFlowRemoved.Builder setHardTimeout(int hardTimeout) {
            this.hardTimeout = hardTimeout;
            this.hardTimeoutSet = true;
            return this;
        }

        @Override
        public Stat getStats() {
            return this.stats;
        }

        @Override
        public OFFlowRemoved.Builder setStats(Stat stats) {
            this.stats = stats;
            this.statsSet = true;
            return this;
        }

        @Override
        public OFFlowRemoved build() {
            Match match;
            U64 cookie;
            TableId tableId;
            long xid = this.xidSet ? this.xid : 0L;
            TableId tableId2 = tableId = this.tableIdSet ? this.tableId : DEFAULT_TABLE_ID;
            if (tableId == null) {
                throw new NullPointerException("Property tableId must not be null");
            }
            if (!this.reasonSet) {
                throw new IllegalStateException("Property reason doesn't have default value -- must be set");
            }
            if (this.reason == null) {
                throw new NullPointerException("Property reason must not be null");
            }
            int priority = this.prioritySet ? this.priority : 0;
            int idleTimeout = this.idleTimeoutSet ? this.idleTimeout : 0;
            int hardTimeout = this.hardTimeoutSet ? this.hardTimeout : 0;
            U64 u64 = cookie = this.cookieSet ? this.cookie : DEFAULT_COOKIE;
            if (cookie == null) {
                throw new NullPointerException("Property cookie must not be null");
            }
            Match match2 = match = this.matchSet ? this.match : DEFAULT_MATCH;
            if (match == null) {
                throw new NullPointerException("Property match must not be null");
            }
            if (!this.statsSet) {
                throw new IllegalStateException("Property stats doesn't have default value -- must be set");
            }
            if (this.stats == null) {
                throw new NullPointerException("Property stats must not be null");
            }
            return new OFFlowRemovedVer15(xid, tableId, this.reason, priority, idleTimeout, hardTimeout, cookie, match, this.stats);
        }
    }

    static class BuilderWithParent
    implements OFFlowRemoved.Builder {
        final OFFlowRemovedVer15 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean tableIdSet;
        private TableId tableId;
        private boolean reasonSet;
        private OFFlowRemovedReason reason;
        private boolean prioritySet;
        private int priority;
        private boolean idleTimeoutSet;
        private int idleTimeout;
        private boolean hardTimeoutSet;
        private int hardTimeout;
        private boolean cookieSet;
        private U64 cookie;
        private boolean matchSet;
        private Match match;
        private boolean statsSet;
        private Stat stats;

        BuilderWithParent(OFFlowRemovedVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFType getType() {
            return OFType.FLOW_REMOVED;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFFlowRemoved.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public Match getMatch() {
            return this.match;
        }

        @Override
        public OFFlowRemoved.Builder setMatch(Match match) {
            this.match = match;
            this.matchSet = true;
            return this;
        }

        @Override
        public U64 getCookie() {
            return this.cookie;
        }

        @Override
        public OFFlowRemoved.Builder setCookie(U64 cookie) {
            this.cookie = cookie;
            this.cookieSet = true;
            return this;
        }

        @Override
        public int getPriority() {
            return this.priority;
        }

        @Override
        public OFFlowRemoved.Builder setPriority(int priority) {
            this.priority = priority;
            this.prioritySet = true;
            return this;
        }

        @Override
        public OFFlowRemovedReason getReason() {
            return this.reason;
        }

        @Override
        public OFFlowRemoved.Builder setReason(OFFlowRemovedReason reason) {
            this.reason = reason;
            this.reasonSet = true;
            return this;
        }

        @Override
        public long getDurationSec() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property durationSec not supported in version 1.5");
        }

        @Override
        public OFFlowRemoved.Builder setDurationSec(long durationSec) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property durationSec not supported in version 1.5");
        }

        @Override
        public long getDurationNsec() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property durationNsec not supported in version 1.5");
        }

        @Override
        public OFFlowRemoved.Builder setDurationNsec(long durationNsec) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property durationNsec not supported in version 1.5");
        }

        @Override
        public int getIdleTimeout() {
            return this.idleTimeout;
        }

        @Override
        public OFFlowRemoved.Builder setIdleTimeout(int idleTimeout) {
            this.idleTimeout = idleTimeout;
            this.idleTimeoutSet = true;
            return this;
        }

        @Override
        public U64 getPacketCount() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property packetCount not supported in version 1.5");
        }

        @Override
        public OFFlowRemoved.Builder setPacketCount(U64 packetCount) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property packetCount not supported in version 1.5");
        }

        @Override
        public U64 getByteCount() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property byteCount not supported in version 1.5");
        }

        @Override
        public OFFlowRemoved.Builder setByteCount(U64 byteCount) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property byteCount not supported in version 1.5");
        }

        @Override
        public TableId getTableId() {
            return this.tableId;
        }

        @Override
        public OFFlowRemoved.Builder setTableId(TableId tableId) {
            this.tableId = tableId;
            this.tableIdSet = true;
            return this;
        }

        @Override
        public int getHardTimeout() {
            return this.hardTimeout;
        }

        @Override
        public OFFlowRemoved.Builder setHardTimeout(int hardTimeout) {
            this.hardTimeout = hardTimeout;
            this.hardTimeoutSet = true;
            return this;
        }

        @Override
        public Stat getStats() {
            return this.stats;
        }

        @Override
        public OFFlowRemoved.Builder setStats(Stat stats) {
            this.stats = stats;
            this.statsSet = true;
            return this;
        }

        @Override
        public OFFlowRemoved build() {
            Stat stats;
            Match match;
            U64 cookie;
            OFFlowRemovedReason reason;
            TableId tableId;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            TableId tableId2 = tableId = this.tableIdSet ? this.tableId : this.parentMessage.tableId;
            if (tableId == null) {
                throw new NullPointerException("Property tableId must not be null");
            }
            OFFlowRemovedReason oFFlowRemovedReason = reason = this.reasonSet ? this.reason : this.parentMessage.reason;
            if (reason == null) {
                throw new NullPointerException("Property reason must not be null");
            }
            int priority = this.prioritySet ? this.priority : this.parentMessage.priority;
            int idleTimeout = this.idleTimeoutSet ? this.idleTimeout : this.parentMessage.idleTimeout;
            int hardTimeout = this.hardTimeoutSet ? this.hardTimeout : this.parentMessage.hardTimeout;
            U64 u64 = cookie = this.cookieSet ? this.cookie : this.parentMessage.cookie;
            if (cookie == null) {
                throw new NullPointerException("Property cookie must not be null");
            }
            Match match2 = match = this.matchSet ? this.match : this.parentMessage.match;
            if (match == null) {
                throw new NullPointerException("Property match must not be null");
            }
            Stat stat = stats = this.statsSet ? this.stats : this.parentMessage.stats;
            if (stats == null) {
                throw new NullPointerException("Property stats must not be null");
            }
            return new OFFlowRemovedVer15(xid, tableId, reason, priority, idleTimeout, hardTimeout, cookie, match, stats);
        }
    }
}

