/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvTcpDst;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvTcpDstVer15
implements OFBsnTlvTcpDst {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvTcpDstVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 6;
    private static final int DEFAULT_VALUE = 0;
    private final int value;
    static final OFBsnTlvTcpDstVer15 DEFAULT = new OFBsnTlvTcpDstVer15(0);
    static final Reader READER = new Reader();
    static final OFBsnTlvTcpDstVer15Funnel FUNNEL = new OFBsnTlvTcpDstVer15Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvTcpDstVer15(int value) {
        this.value = U16.normalize(value);
    }

    @Override
    public int getType() {
        return 66;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFBsnTlvTcpDst.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvTcpDstVer15(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvTcpDstVer15 other = (OFBsnTlvTcpDstVer15)obj;
        return this.value == other.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.value;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvTcpDstVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvTcpDstVer15 message) {
            bb.writeShort(66);
            bb.writeShort(6);
            bb.writeShort((int)U16.t(message.value));
        }
    }

    static class OFBsnTlvTcpDstVer15Funnel
    implements Funnel<OFBsnTlvTcpDstVer15> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvTcpDstVer15Funnel() {
        }

        public void funnel(OFBsnTlvTcpDstVer15 message, PrimitiveSink sink) {
            sink.putShort((short)66);
            sink.putShort((short)6);
            sink.putInt(message.value);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvTcpDst> {
        Reader() {
        }

        @Override
        public OFBsnTlvTcpDst readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 66) {
                throw new OFParseError("Wrong type: Expected=0x42(0x42), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 6) {
                throw new OFParseError("Wrong length: Expected=6(6), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            int value = U16.f(bb.readShort());
            OFBsnTlvTcpDstVer15 bsnTlvTcpDstVer15 = new OFBsnTlvTcpDstVer15(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvTcpDstVer15);
            }
            return bsnTlvTcpDstVer15;
        }
    }

    static class Builder
    implements OFBsnTlvTcpDst.Builder {
        private boolean valueSet;
        private int value;

        Builder() {
        }

        @Override
        public int getType() {
            return 66;
        }

        @Override
        public int getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvTcpDst.Builder setValue(int value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvTcpDst build() {
            int value = this.valueSet ? this.value : 0;
            return new OFBsnTlvTcpDstVer15(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvTcpDst.Builder {
        final OFBsnTlvTcpDstVer15 parentMessage;
        private boolean valueSet;
        private int value;

        BuilderWithParent(OFBsnTlvTcpDstVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 66;
        }

        @Override
        public int getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvTcpDst.Builder setValue(int value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvTcpDst build() {
            int value = this.valueSet ? this.value : this.parentMessage.value;
            return new OFBsnTlvTcpDstVer15(value);
        }
    }
}

