/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.Set;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnPushVlan;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvPushVlanOnIngress;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnPushVlanSerializerVer15;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvPushVlanOnIngressVer15
implements OFBsnTlvPushVlanOnIngress {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvPushVlanOnIngressVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 5;
    private static final Set<OFBsnPushVlan> DEFAULT_FLAGS = ImmutableSet.of();
    private final Set<OFBsnPushVlan> flags;
    static final OFBsnTlvPushVlanOnIngressVer15 DEFAULT = new OFBsnTlvPushVlanOnIngressVer15(DEFAULT_FLAGS);
    static final Reader READER = new Reader();
    static final OFBsnTlvPushVlanOnIngressVer15Funnel FUNNEL = new OFBsnTlvPushVlanOnIngressVer15Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvPushVlanOnIngressVer15(Set<OFBsnPushVlan> flags) {
        if (flags == null) {
            throw new NullPointerException("OFBsnTlvPushVlanOnIngressVer15: property flags cannot be null");
        }
        this.flags = flags;
    }

    @Override
    public int getType() {
        return 128;
    }

    @Override
    public Set<OFBsnPushVlan> getFlags() {
        return this.flags;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFBsnTlvPushVlanOnIngress.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvPushVlanOnIngressVer15(");
        b.append("flags=").append(this.flags);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvPushVlanOnIngressVer15 other = (OFBsnTlvPushVlanOnIngressVer15)obj;
        return !(this.flags == null ? other.flags != null : !this.flags.equals(other.flags));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvPushVlanOnIngressVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvPushVlanOnIngressVer15 message) {
            bb.writeShort(128);
            bb.writeShort(5);
            OFBsnPushVlanSerializerVer15.writeTo(bb, message.flags);
        }
    }

    static class OFBsnTlvPushVlanOnIngressVer15Funnel
    implements Funnel<OFBsnTlvPushVlanOnIngressVer15> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvPushVlanOnIngressVer15Funnel() {
        }

        public void funnel(OFBsnTlvPushVlanOnIngressVer15 message, PrimitiveSink sink) {
            sink.putShort((short)128);
            sink.putShort((short)5);
            OFBsnPushVlanSerializerVer15.putTo(message.flags, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvPushVlanOnIngress> {
        Reader() {
        }

        @Override
        public OFBsnTlvPushVlanOnIngress readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 128) {
                throw new OFParseError("Wrong type: Expected=0x80(0x80), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 5) {
                throw new OFParseError("Wrong length: Expected=5(5), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            Set<OFBsnPushVlan> flags = OFBsnPushVlanSerializerVer15.readFrom(bb);
            OFBsnTlvPushVlanOnIngressVer15 bsnTlvPushVlanOnIngressVer15 = new OFBsnTlvPushVlanOnIngressVer15(flags);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvPushVlanOnIngressVer15);
            }
            return bsnTlvPushVlanOnIngressVer15;
        }
    }

    static class Builder
    implements OFBsnTlvPushVlanOnIngress.Builder {
        private boolean flagsSet;
        private Set<OFBsnPushVlan> flags;

        Builder() {
        }

        @Override
        public int getType() {
            return 128;
        }

        @Override
        public Set<OFBsnPushVlan> getFlags() {
            return this.flags;
        }

        @Override
        public OFBsnTlvPushVlanOnIngress.Builder setFlags(Set<OFBsnPushVlan> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvPushVlanOnIngress build() {
            Set<OFBsnPushVlan> flags;
            Set<OFBsnPushVlan> set = flags = this.flagsSet ? this.flags : DEFAULT_FLAGS;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            return new OFBsnTlvPushVlanOnIngressVer15(flags);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvPushVlanOnIngress.Builder {
        final OFBsnTlvPushVlanOnIngressVer15 parentMessage;
        private boolean flagsSet;
        private Set<OFBsnPushVlan> flags;

        BuilderWithParent(OFBsnTlvPushVlanOnIngressVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 128;
        }

        @Override
        public Set<OFBsnPushVlan> getFlags() {
            return this.flags;
        }

        @Override
        public OFBsnTlvPushVlanOnIngress.Builder setFlags(Set<OFBsnPushVlan> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvPushVlanOnIngress build() {
            Set flags;
            Set set = flags = this.flagsSet ? this.flags : this.parentMessage.flags;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            return new OFBsnTlvPushVlanOnIngressVer15(flags);
        }
    }
}

