/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.Set;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnHashPacketField;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvHashPacketField;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnHashPacketFieldSerializerVer15;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvHashPacketFieldVer15
implements OFBsnTlvHashPacketField {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvHashPacketFieldVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 12;
    private static final Set<OFBsnHashPacketField> DEFAULT_VALUE = ImmutableSet.of();
    private final Set<OFBsnHashPacketField> value;
    static final OFBsnTlvHashPacketFieldVer15 DEFAULT = new OFBsnTlvHashPacketFieldVer15(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFBsnTlvHashPacketFieldVer15Funnel FUNNEL = new OFBsnTlvHashPacketFieldVer15Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvHashPacketFieldVer15(Set<OFBsnHashPacketField> value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvHashPacketFieldVer15: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 103;
    }

    @Override
    public Set<OFBsnHashPacketField> getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFBsnTlvHashPacketField.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvHashPacketFieldVer15(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvHashPacketFieldVer15 other = (OFBsnTlvHashPacketFieldVer15)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvHashPacketFieldVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvHashPacketFieldVer15 message) {
            bb.writeShort(103);
            bb.writeShort(12);
            OFBsnHashPacketFieldSerializerVer15.writeTo(bb, message.value);
        }
    }

    static class OFBsnTlvHashPacketFieldVer15Funnel
    implements Funnel<OFBsnTlvHashPacketFieldVer15> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvHashPacketFieldVer15Funnel() {
        }

        public void funnel(OFBsnTlvHashPacketFieldVer15 message, PrimitiveSink sink) {
            sink.putShort((short)103);
            sink.putShort((short)12);
            OFBsnHashPacketFieldSerializerVer15.putTo(message.value, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvHashPacketField> {
        Reader() {
        }

        @Override
        public OFBsnTlvHashPacketField readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 103) {
                throw new OFParseError("Wrong type: Expected=0x67(0x67), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 12) {
                throw new OFParseError("Wrong length: Expected=12(12), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            Set<OFBsnHashPacketField> value = OFBsnHashPacketFieldSerializerVer15.readFrom(bb);
            OFBsnTlvHashPacketFieldVer15 bsnTlvHashPacketFieldVer15 = new OFBsnTlvHashPacketFieldVer15(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvHashPacketFieldVer15);
            }
            return bsnTlvHashPacketFieldVer15;
        }
    }

    static class Builder
    implements OFBsnTlvHashPacketField.Builder {
        private boolean valueSet;
        private Set<OFBsnHashPacketField> value;

        Builder() {
        }

        @Override
        public int getType() {
            return 103;
        }

        @Override
        public Set<OFBsnHashPacketField> getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvHashPacketField.Builder setValue(Set<OFBsnHashPacketField> value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvHashPacketField build() {
            Set<OFBsnHashPacketField> value;
            Set<OFBsnHashPacketField> set = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvHashPacketFieldVer15(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvHashPacketField.Builder {
        final OFBsnTlvHashPacketFieldVer15 parentMessage;
        private boolean valueSet;
        private Set<OFBsnHashPacketField> value;

        BuilderWithParent(OFBsnTlvHashPacketFieldVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 103;
        }

        @Override
        public Set<OFBsnHashPacketField> getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvHashPacketField.Builder setValue(Set<OFBsnHashPacketField> value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvHashPacketField build() {
            Set value;
            Set set = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvHashPacketFieldVer15(value);
        }
    }
}

