/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnLacpState;

public class OFBsnLacpStateSerializerVer15 {
    public static final byte BSN_LACP_STATE_ACTIVITY_VAL = 1;
    public static final byte BSN_LACP_STATE_TIMEOUT_VAL = 2;
    public static final byte BSN_LACP_STATE_AGGREGATION_VAL = 4;
    public static final byte BSN_LACP_STATE_SYNCHRONIZATION_VAL = 8;
    public static final byte BSN_LACP_STATE_COLLECTING_VAL = 16;
    public static final byte BSN_LACP_STATE_DISTRIBUTING_VAL = 32;
    public static final byte BSN_LACP_STATE_DEFAULTED_VAL = 64;
    public static final byte BSN_LACP_STATE_EXPIRED_VAL = -128;

    public static Set<OFBsnLacpState> readFrom(ByteBuf bb) throws OFParseError {
        try {
            return OFBsnLacpStateSerializerVer15.ofWireValue(bb.readByte());
        }
        catch (IllegalArgumentException e) {
            throw new OFParseError(e);
        }
    }

    public static void writeTo(ByteBuf bb, Set<OFBsnLacpState> set) {
        bb.writeByte((int)OFBsnLacpStateSerializerVer15.toWireValue(set));
    }

    public static void putTo(Set<OFBsnLacpState> set, PrimitiveSink sink) {
        sink.putByte(OFBsnLacpStateSerializerVer15.toWireValue(set));
    }

    public static Set<OFBsnLacpState> ofWireValue(byte val) {
        EnumSet<OFBsnLacpState> set = EnumSet.noneOf(OFBsnLacpState.class);
        if ((val & 1) != 0) {
            set.add(OFBsnLacpState.BSN_LACP_STATE_ACTIVITY);
        }
        if ((val & 2) != 0) {
            set.add(OFBsnLacpState.BSN_LACP_STATE_TIMEOUT);
        }
        if ((val & 4) != 0) {
            set.add(OFBsnLacpState.BSN_LACP_STATE_AGGREGATION);
        }
        if ((val & 8) != 0) {
            set.add(OFBsnLacpState.BSN_LACP_STATE_SYNCHRONIZATION);
        }
        if ((val & 0x10) != 0) {
            set.add(OFBsnLacpState.BSN_LACP_STATE_COLLECTING);
        }
        if ((val & 0x20) != 0) {
            set.add(OFBsnLacpState.BSN_LACP_STATE_DISTRIBUTING);
        }
        if ((val & 0x40) != 0) {
            set.add(OFBsnLacpState.BSN_LACP_STATE_DEFAULTED);
        }
        if ((val & 0xFFFFFF80) != 0) {
            set.add(OFBsnLacpState.BSN_LACP_STATE_EXPIRED);
        }
        return Collections.unmodifiableSet(set);
    }

    public static byte toWireValue(Set<OFBsnLacpState> set) {
        byte wireValue = 0;
        block10: for (OFBsnLacpState e : set) {
            switch (e) {
                case BSN_LACP_STATE_ACTIVITY: {
                    wireValue = (byte)(wireValue | 1);
                    continue block10;
                }
                case BSN_LACP_STATE_TIMEOUT: {
                    wireValue = (byte)(wireValue | 2);
                    continue block10;
                }
                case BSN_LACP_STATE_AGGREGATION: {
                    wireValue = (byte)(wireValue | 4);
                    continue block10;
                }
                case BSN_LACP_STATE_SYNCHRONIZATION: {
                    wireValue = (byte)(wireValue | 8);
                    continue block10;
                }
                case BSN_LACP_STATE_COLLECTING: {
                    wireValue = (byte)(wireValue | 0x10);
                    continue block10;
                }
                case BSN_LACP_STATE_DISTRIBUTING: {
                    wireValue = (byte)(wireValue | 0x20);
                    continue block10;
                }
                case BSN_LACP_STATE_DEFAULTED: {
                    wireValue = (byte)(wireValue | 0x40);
                    continue block10;
                }
                case BSN_LACP_STATE_EXPIRED: {
                    wireValue = (byte)(wireValue | 0xFFFFFF80);
                    continue block10;
                }
            }
            throw new IllegalArgumentException("Illegal enum value for type OFBsnLacpState in version 1.5: " + (Object)((Object)e));
        }
        return wireValue;
    }
}

