/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnFlowChecksumBucketStatsEntry;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnFlowChecksumBucketStatsEntryVer15
implements OFBsnFlowChecksumBucketStatsEntry {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnFlowChecksumBucketStatsEntryVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 8;
    private static final U64 DEFAULT_CHECKSUM = U64.ZERO;
    private final U64 checksum;
    static final OFBsnFlowChecksumBucketStatsEntryVer15 DEFAULT = new OFBsnFlowChecksumBucketStatsEntryVer15(DEFAULT_CHECKSUM);
    static final Reader READER = new Reader();
    static final OFBsnFlowChecksumBucketStatsEntryVer15Funnel FUNNEL = new OFBsnFlowChecksumBucketStatsEntryVer15Funnel();
    static final Writer WRITER = new Writer();

    OFBsnFlowChecksumBucketStatsEntryVer15(U64 checksum) {
        if (checksum == null) {
            throw new NullPointerException("OFBsnFlowChecksumBucketStatsEntryVer15: property checksum cannot be null");
        }
        this.checksum = checksum;
    }

    @Override
    public U64 getChecksum() {
        return this.checksum;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFBsnFlowChecksumBucketStatsEntry.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnFlowChecksumBucketStatsEntryVer15(");
        b.append("checksum=").append(this.checksum);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnFlowChecksumBucketStatsEntryVer15 other = (OFBsnFlowChecksumBucketStatsEntryVer15)obj;
        return !(this.checksum == null ? other.checksum != null : !this.checksum.equals(other.checksum));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.checksum == null ? 0 : this.checksum.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnFlowChecksumBucketStatsEntryVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnFlowChecksumBucketStatsEntryVer15 message) {
            bb.writeLong(message.checksum.getValue());
        }
    }

    static class OFBsnFlowChecksumBucketStatsEntryVer15Funnel
    implements Funnel<OFBsnFlowChecksumBucketStatsEntryVer15> {
        private static final long serialVersionUID = 1L;

        OFBsnFlowChecksumBucketStatsEntryVer15Funnel() {
        }

        public void funnel(OFBsnFlowChecksumBucketStatsEntryVer15 message, PrimitiveSink sink) {
            message.checksum.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnFlowChecksumBucketStatsEntry> {
        Reader() {
        }

        @Override
        public OFBsnFlowChecksumBucketStatsEntry readFrom(ByteBuf bb) throws OFParseError {
            U64 checksum = U64.ofRaw(bb.readLong());
            OFBsnFlowChecksumBucketStatsEntryVer15 bsnFlowChecksumBucketStatsEntryVer15 = new OFBsnFlowChecksumBucketStatsEntryVer15(checksum);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnFlowChecksumBucketStatsEntryVer15);
            }
            return bsnFlowChecksumBucketStatsEntryVer15;
        }
    }

    static class Builder
    implements OFBsnFlowChecksumBucketStatsEntry.Builder {
        private boolean checksumSet;
        private U64 checksum;

        Builder() {
        }

        @Override
        public U64 getChecksum() {
            return this.checksum;
        }

        @Override
        public OFBsnFlowChecksumBucketStatsEntry.Builder setChecksum(U64 checksum) {
            this.checksum = checksum;
            this.checksumSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnFlowChecksumBucketStatsEntry build() {
            U64 checksum;
            U64 u64 = checksum = this.checksumSet ? this.checksum : DEFAULT_CHECKSUM;
            if (checksum == null) {
                throw new NullPointerException("Property checksum must not be null");
            }
            return new OFBsnFlowChecksumBucketStatsEntryVer15(checksum);
        }
    }

    static class BuilderWithParent
    implements OFBsnFlowChecksumBucketStatsEntry.Builder {
        final OFBsnFlowChecksumBucketStatsEntryVer15 parentMessage;
        private boolean checksumSet;
        private U64 checksum;

        BuilderWithParent(OFBsnFlowChecksumBucketStatsEntryVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public U64 getChecksum() {
            return this.checksum;
        }

        @Override
        public OFBsnFlowChecksumBucketStatsEntry.Builder setChecksum(U64 checksum) {
            this.checksum = checksum;
            this.checksumSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnFlowChecksumBucketStatsEntry build() {
            U64 checksum;
            U64 u64 = checksum = this.checksumSet ? this.checksum : this.parentMessage.checksum;
            if (checksum == null) {
                throw new NullPointerException("Property checksum must not be null");
            }
            return new OFBsnFlowChecksumBucketStatsEntryVer15(checksum);
        }
    }
}

