/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFAsyncConfigPropContStatusMaster;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFAsyncConfigPropContStatusMasterVer15
implements OFAsyncConfigPropContStatusMaster {
    private static final Logger logger = LoggerFactory.getLogger(OFAsyncConfigPropContStatusMasterVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 8;
    private static final long DEFAULT_MASK = 0L;
    private final long mask;
    static final OFAsyncConfigPropContStatusMasterVer15 DEFAULT = new OFAsyncConfigPropContStatusMasterVer15(0L);
    static final Reader READER = new Reader();
    static final OFAsyncConfigPropContStatusMasterVer15Funnel FUNNEL = new OFAsyncConfigPropContStatusMasterVer15Funnel();
    static final Writer WRITER = new Writer();

    OFAsyncConfigPropContStatusMasterVer15(long mask) {
        this.mask = U32.normalize(mask);
    }

    @Override
    public int getType() {
        return 15;
    }

    @Override
    public long getMask() {
        return this.mask;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFAsyncConfigPropContStatusMaster.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFAsyncConfigPropContStatusMasterVer15(");
        b.append("mask=").append(this.mask);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFAsyncConfigPropContStatusMasterVer15 other = (OFAsyncConfigPropContStatusMasterVer15)obj;
        return this.mask == other.mask;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.mask ^ this.mask >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFAsyncConfigPropContStatusMasterVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFAsyncConfigPropContStatusMasterVer15 message) {
            bb.writeShort(15);
            bb.writeShort(8);
            bb.writeInt(U32.t(message.mask));
        }
    }

    static class OFAsyncConfigPropContStatusMasterVer15Funnel
    implements Funnel<OFAsyncConfigPropContStatusMasterVer15> {
        private static final long serialVersionUID = 1L;

        OFAsyncConfigPropContStatusMasterVer15Funnel() {
        }

        public void funnel(OFAsyncConfigPropContStatusMasterVer15 message, PrimitiveSink sink) {
            sink.putShort((short)15);
            sink.putShort((short)8);
            sink.putLong(message.mask);
        }
    }

    static class Reader
    implements OFMessageReader<OFAsyncConfigPropContStatusMaster> {
        Reader() {
        }

        @Override
        public OFAsyncConfigPropContStatusMaster readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 15) {
                throw new OFParseError("Wrong type: Expected=0xf(0xf), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long mask = U32.f(bb.readInt());
            OFAsyncConfigPropContStatusMasterVer15 asyncConfigPropContStatusMasterVer15 = new OFAsyncConfigPropContStatusMasterVer15(mask);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)asyncConfigPropContStatusMasterVer15);
            }
            return asyncConfigPropContStatusMasterVer15;
        }
    }

    static class Builder
    implements OFAsyncConfigPropContStatusMaster.Builder {
        private boolean maskSet;
        private long mask;

        Builder() {
        }

        @Override
        public int getType() {
            return 15;
        }

        @Override
        public long getMask() {
            return this.mask;
        }

        @Override
        public OFAsyncConfigPropContStatusMaster.Builder setMask(long mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFAsyncConfigPropContStatusMaster build() {
            long mask = this.maskSet ? this.mask : 0L;
            return new OFAsyncConfigPropContStatusMasterVer15(mask);
        }
    }

    static class BuilderWithParent
    implements OFAsyncConfigPropContStatusMaster.Builder {
        final OFAsyncConfigPropContStatusMasterVer15 parentMessage;
        private boolean maskSet;
        private long mask;

        BuilderWithParent(OFAsyncConfigPropContStatusMasterVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 15;
        }

        @Override
        public long getMask() {
            return this.mask;
        }

        @Override
        public OFAsyncConfigPropContStatusMaster.Builder setMask(long mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFAsyncConfigPropContStatusMaster build() {
            long mask = this.maskSet ? this.mask : this.parentMessage.mask;
            return new OFAsyncConfigPropContStatusMasterVer15(mask);
        }
    }
}

