/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFTableDesc;
import org.projectfloodlight.openflow.protocol.OFTableReason;
import org.projectfloodlight.openflow.protocol.OFTableStatus;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver14.OFTableDescVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFTableReasonSerializerVer14;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFTableStatusVer14
implements OFTableStatus {
    private static final Logger logger = LoggerFactory.getLogger(OFTableStatusVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 28;
    private static final long DEFAULT_XID = 0L;
    private static final long DEFAULT_ROLE = 0L;
    private final long xid;
    private final long role;
    private final OFTableReason reason;
    private final OFTableDesc table;
    static final Reader READER = new Reader();
    static final OFTableStatusVer14Funnel FUNNEL = new OFTableStatusVer14Funnel();
    static final Writer WRITER = new Writer();

    OFTableStatusVer14(long xid, long role, OFTableReason reason, OFTableDesc table) {
        if (reason == null) {
            throw new NullPointerException("OFTableStatusVer14: property reason cannot be null");
        }
        if (table == null) {
            throw new NullPointerException("OFTableStatusVer14: property table cannot be null");
        }
        this.xid = U32.normalize(xid);
        this.role = U32.normalize(role);
        this.reason = reason;
        this.table = table;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFType getType() {
        return OFType.TABLE_STATUS;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public long getRole() {
        return this.role;
    }

    @Override
    public OFTableReason getReason() {
        return this.reason;
    }

    @Override
    public OFTableDesc getTable() {
        return this.table;
    }

    @Override
    public OFTableStatus.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFTableStatusVer14(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("role=").append(this.role);
        b.append(", ");
        b.append("reason=").append((Object)this.reason);
        b.append(", ");
        b.append("table=").append(this.table);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFTableStatusVer14 other = (OFTableStatusVer14)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.role != other.role) {
            return false;
        }
        if (this.reason == null ? other.reason != null : !this.reason.equals((Object)other.reason)) {
            return false;
        }
        return !(this.table == null ? other.table != null : !this.table.equals(other.table));
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFTableStatusVer14 other = (OFTableStatusVer14)obj;
        if (this.role != other.role) {
            return false;
        }
        if (this.reason == null ? other.reason != null : !this.reason.equals((Object)other.reason)) {
            return false;
        }
        return !(this.table == null ? other.table != null : !this.table.equals(other.table));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * (int)(this.role ^ this.role >>> 32);
        result = 31 * result + (this.reason == null ? 0 : this.reason.hashCode());
        result = 31 * result + (this.table == null ? 0 : this.table.hashCode());
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.role ^ this.role >>> 32);
        result = 31 * result + (this.reason == null ? 0 : this.reason.hashCode());
        result = 31 * result + (this.table == null ? 0 : this.table.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFTableStatusVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFTableStatusVer14 message) {
            bb.writeByte(5);
            bb.writeByte(31);
            bb.writeShort(28);
            bb.writeInt(U32.t(message.xid));
            bb.writeInt(U32.t(message.role));
            OFTableReasonSerializerVer14.writeTo(bb, message.reason);
            bb.writeZero(7);
            message.table.writeTo(bb);
        }
    }

    static class OFTableStatusVer14Funnel
    implements Funnel<OFTableStatusVer14> {
        private static final long serialVersionUID = 1L;

        OFTableStatusVer14Funnel() {
        }

        public void funnel(OFTableStatusVer14 message, PrimitiveSink sink) {
            sink.putByte((byte)5);
            sink.putByte((byte)31);
            sink.putShort((short)28);
            sink.putLong(message.xid);
            sink.putLong(message.role);
            OFTableReasonSerializerVer14.putTo(message.reason, sink);
            message.table.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFTableStatus> {
        Reader() {
        }

        @Override
        public OFTableStatus readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 5) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_14(5), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 31) {
                throw new OFParseError("Wrong type: Expected=OFType.TABLE_STATUS(31), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 28) {
                throw new OFParseError("Wrong length: Expected=28(28), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            long role = U32.f(bb.readInt());
            OFTableReason reason = OFTableReasonSerializerVer14.readFrom(bb);
            bb.skipBytes(7);
            OFTableDesc table = OFTableDescVer14.READER.readFrom(bb);
            OFTableStatusVer14 tableStatusVer14 = new OFTableStatusVer14(xid, role, reason, table);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)tableStatusVer14);
            }
            return tableStatusVer14;
        }
    }

    static class Builder
    implements OFTableStatus.Builder {
        private boolean xidSet;
        private long xid;
        private boolean roleSet;
        private long role;
        private boolean reasonSet;
        private OFTableReason reason;
        private boolean tableSet;
        private OFTableDesc table;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFType getType() {
            return OFType.TABLE_STATUS;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFTableStatus.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getRole() {
            return this.role;
        }

        @Override
        public OFTableStatus.Builder setRole(long role) {
            this.role = role;
            this.roleSet = true;
            return this;
        }

        @Override
        public OFTableReason getReason() {
            return this.reason;
        }

        @Override
        public OFTableStatus.Builder setReason(OFTableReason reason) {
            this.reason = reason;
            this.reasonSet = true;
            return this;
        }

        @Override
        public OFTableDesc getTable() {
            return this.table;
        }

        @Override
        public OFTableStatus.Builder setTable(OFTableDesc table) {
            this.table = table;
            this.tableSet = true;
            return this;
        }

        @Override
        public OFTableStatus build() {
            long role;
            long xid = this.xidSet ? this.xid : 0L;
            long l = role = this.roleSet ? this.role : 0L;
            if (!this.reasonSet) {
                throw new IllegalStateException("Property reason doesn't have default value -- must be set");
            }
            if (this.reason == null) {
                throw new NullPointerException("Property reason must not be null");
            }
            if (!this.tableSet) {
                throw new IllegalStateException("Property table doesn't have default value -- must be set");
            }
            if (this.table == null) {
                throw new NullPointerException("Property table must not be null");
            }
            return new OFTableStatusVer14(xid, role, this.reason, this.table);
        }
    }

    static class BuilderWithParent
    implements OFTableStatus.Builder {
        final OFTableStatusVer14 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean roleSet;
        private long role;
        private boolean reasonSet;
        private OFTableReason reason;
        private boolean tableSet;
        private OFTableDesc table;

        BuilderWithParent(OFTableStatusVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFType getType() {
            return OFType.TABLE_STATUS;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFTableStatus.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getRole() {
            return this.role;
        }

        @Override
        public OFTableStatus.Builder setRole(long role) {
            this.role = role;
            this.roleSet = true;
            return this;
        }

        @Override
        public OFTableReason getReason() {
            return this.reason;
        }

        @Override
        public OFTableStatus.Builder setReason(OFTableReason reason) {
            this.reason = reason;
            this.reasonSet = true;
            return this;
        }

        @Override
        public OFTableDesc getTable() {
            return this.table;
        }

        @Override
        public OFTableStatus.Builder setTable(OFTableDesc table) {
            this.table = table;
            this.tableSet = true;
            return this;
        }

        @Override
        public OFTableStatus build() {
            OFTableDesc table;
            OFTableReason reason;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            long role = this.roleSet ? this.role : this.parentMessage.role;
            OFTableReason oFTableReason = reason = this.reasonSet ? this.reason : this.parentMessage.reason;
            if (reason == null) {
                throw new NullPointerException("Property reason must not be null");
            }
            OFTableDesc oFTableDesc = table = this.tableSet ? this.table : this.parentMessage.table;
            if (table == null) {
                throw new NullPointerException("Property table must not be null");
            }
            return new OFTableStatusVer14(xid, role, reason, table);
        }
    }
}

