/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmVlanVid;
import org.projectfloodlight.openflow.types.OFVlanVidMatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmVlanVidVer14
implements OFOxmVlanVid {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmVlanVidVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 6;
    private static final OFVlanVidMatch DEFAULT_VALUE = OFVlanVidMatch.NONE;
    private final OFVlanVidMatch value;
    static final OFOxmVlanVidVer14 DEFAULT = new OFOxmVlanVidVer14(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmVlanVidVer14Funnel FUNNEL = new OFOxmVlanVidVer14Funnel();
    static final Writer WRITER = new Writer();

    OFOxmVlanVidVer14(OFVlanVidMatch value) {
        if (value == null) {
            throw new NullPointerException("OFOxmVlanVidVer14: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 2147486722L;
    }

    @Override
    public OFVlanVidMatch getValue() {
        return this.value;
    }

    @Override
    public MatchField<OFVlanVidMatch> getMatchField() {
        return MatchField.VLAN_VID;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<OFVlanVidMatch> getCanonical() {
        return this;
    }

    @Override
    public OFVlanVidMatch getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.4");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFOxmVlanVid.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmVlanVidVer14(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmVlanVidVer14 other = (OFOxmVlanVidVer14)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmVlanVidVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFOxmVlanVidVer14 message) {
            bb.writeInt(-2147480574);
            message.value.write2Bytes(bb);
        }
    }

    static class OFOxmVlanVidVer14Funnel
    implements Funnel<OFOxmVlanVidVer14> {
        private static final long serialVersionUID = 1L;

        OFOxmVlanVidVer14Funnel() {
        }

        public void funnel(OFOxmVlanVidVer14 message, PrimitiveSink sink) {
            sink.putInt(-2147480574);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmVlanVid> {
        Reader() {
        }

        @Override
        public OFOxmVlanVid readFrom(ByteBuf bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != -2147480574) {
                throw new OFParseError("Wrong typeLen: Expected=0x80000c02L(0x80000c02L), got=" + typeLen);
            }
            OFVlanVidMatch value = OFVlanVidMatch.read2Bytes(bb);
            OFOxmVlanVidVer14 oxmVlanVidVer14 = new OFOxmVlanVidVer14(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmVlanVidVer14);
            }
            return oxmVlanVidVer14;
        }
    }

    static class Builder
    implements OFOxmVlanVid.Builder {
        private boolean valueSet;
        private OFVlanVidMatch value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 2147486722L;
        }

        @Override
        public OFVlanVidMatch getValue() {
            return this.value;
        }

        @Override
        public OFOxmVlanVid.Builder setValue(OFVlanVidMatch value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<OFVlanVidMatch> getMatchField() {
            return MatchField.VLAN_VID;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<OFVlanVidMatch> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.4");
        }

        @Override
        public OFVlanVidMatch getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.4");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFOxmVlanVid build() {
            OFVlanVidMatch value;
            OFVlanVidMatch oFVlanVidMatch = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmVlanVidVer14(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmVlanVid.Builder {
        final OFOxmVlanVidVer14 parentMessage;
        private boolean valueSet;
        private OFVlanVidMatch value;

        BuilderWithParent(OFOxmVlanVidVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 2147486722L;
        }

        @Override
        public OFVlanVidMatch getValue() {
            return this.value;
        }

        @Override
        public OFOxmVlanVid.Builder setValue(OFVlanVidMatch value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<OFVlanVidMatch> getMatchField() {
            return MatchField.VLAN_VID;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<OFVlanVidMatch> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.4");
        }

        @Override
        public OFVlanVidMatch getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.4");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFOxmVlanVid build() {
            OFVlanVidMatch value;
            OFVlanVidMatch oFVlanVidMatch = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmVlanVidVer14(value);
        }
    }
}

