/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmTunnelIdMasked;
import org.projectfloodlight.openflow.protocol.ver14.OFOxmTunnelIdVer14;
import org.projectfloodlight.openflow.types.U64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmTunnelIdMaskedVer14
implements OFOxmTunnelIdMasked {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmTunnelIdMaskedVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 20;
    private static final U64 DEFAULT_VALUE = U64.ZERO;
    private static final U64 DEFAULT_VALUE_MASK = U64.ZERO;
    private final U64 value;
    private final U64 mask;
    static final OFOxmTunnelIdMaskedVer14 DEFAULT = new OFOxmTunnelIdMaskedVer14(DEFAULT_VALUE, DEFAULT_VALUE_MASK);
    static final Reader READER = new Reader();
    static final OFOxmTunnelIdMaskedVer14Funnel FUNNEL = new OFOxmTunnelIdMaskedVer14Funnel();
    static final Writer WRITER = new Writer();

    OFOxmTunnelIdMaskedVer14(U64 value, U64 mask) {
        if (value == null) {
            throw new NullPointerException("OFOxmTunnelIdMaskedVer14: property value cannot be null");
        }
        if (mask == null) {
            throw new NullPointerException("OFOxmTunnelIdMaskedVer14: property mask cannot be null");
        }
        this.value = value;
        this.mask = mask;
    }

    @Override
    public long getTypeLen() {
        return 2147503376L;
    }

    @Override
    public U64 getValue() {
        return this.value;
    }

    @Override
    public U64 getMask() {
        return this.mask;
    }

    @Override
    public MatchField<U64> getMatchField() {
        return MatchField.TUNNEL_ID;
    }

    @Override
    public boolean isMasked() {
        return true;
    }

    @Override
    public OFOxm<U64> getCanonical() {
        if (U64.NO_MASK.equals(this.mask)) {
            return new OFOxmTunnelIdVer14(this.value);
        }
        if (U64.FULL_MASK.equals(this.mask)) {
            return null;
        }
        return this;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFOxmTunnelIdMasked.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmTunnelIdMaskedVer14(");
        b.append("value=").append(this.value);
        b.append(", ");
        b.append("mask=").append(this.mask);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmTunnelIdMaskedVer14 other = (OFOxmTunnelIdMaskedVer14)obj;
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        return !(this.mask == null ? other.mask != null : !this.mask.equals(other.mask));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.mask == null ? 0 : this.mask.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmTunnelIdMaskedVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFOxmTunnelIdMaskedVer14 message) {
            bb.writeInt(-2147463920);
            bb.writeLong(message.value.getValue());
            bb.writeLong(message.mask.getValue());
        }
    }

    static class OFOxmTunnelIdMaskedVer14Funnel
    implements Funnel<OFOxmTunnelIdMaskedVer14> {
        private static final long serialVersionUID = 1L;

        OFOxmTunnelIdMaskedVer14Funnel() {
        }

        public void funnel(OFOxmTunnelIdMaskedVer14 message, PrimitiveSink sink) {
            sink.putInt(-2147463920);
            message.value.putTo(sink);
            message.mask.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmTunnelIdMasked> {
        Reader() {
        }

        @Override
        public OFOxmTunnelIdMasked readFrom(ByteBuf bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != -2147463920) {
                throw new OFParseError("Wrong typeLen: Expected=0x80004d10L(0x80004d10L), got=" + typeLen);
            }
            U64 value = U64.ofRaw(bb.readLong());
            U64 mask = U64.ofRaw(bb.readLong());
            OFOxmTunnelIdMaskedVer14 oxmTunnelIdMaskedVer14 = new OFOxmTunnelIdMaskedVer14(value, mask);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmTunnelIdMaskedVer14);
            }
            return oxmTunnelIdMaskedVer14;
        }
    }

    static class Builder
    implements OFOxmTunnelIdMasked.Builder {
        private boolean valueSet;
        private U64 value;
        private boolean maskSet;
        private U64 mask;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 2147503376L;
        }

        @Override
        public U64 getValue() {
            return this.value;
        }

        @Override
        public OFOxmTunnelIdMasked.Builder setValue(U64 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public U64 getMask() {
            return this.mask;
        }

        @Override
        public OFOxmTunnelIdMasked.Builder setMask(U64 mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<U64> getMatchField() {
            return MatchField.TUNNEL_ID;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<U64> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.4");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFOxmTunnelIdMasked build() {
            U64 mask;
            U64 value;
            U64 u64 = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            U64 u642 = mask = this.maskSet ? this.mask : DEFAULT_VALUE_MASK;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmTunnelIdMaskedVer14(value, mask);
        }
    }

    static class BuilderWithParent
    implements OFOxmTunnelIdMasked.Builder {
        final OFOxmTunnelIdMaskedVer14 parentMessage;
        private boolean valueSet;
        private U64 value;
        private boolean maskSet;
        private U64 mask;

        BuilderWithParent(OFOxmTunnelIdMaskedVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 2147503376L;
        }

        @Override
        public U64 getValue() {
            return this.value;
        }

        @Override
        public OFOxmTunnelIdMasked.Builder setValue(U64 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public U64 getMask() {
            return this.mask;
        }

        @Override
        public OFOxmTunnelIdMasked.Builder setMask(U64 mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<U64> getMatchField() {
            return MatchField.TUNNEL_ID;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<U64> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.4");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFOxmTunnelIdMasked build() {
            U64 mask;
            U64 value;
            U64 u64 = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            U64 u642 = mask = this.maskSet ? this.mask : this.parentMessage.mask;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmTunnelIdMaskedVer14(value, mask);
        }
    }
}

