/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmBsnUdf5;
import org.projectfloodlight.openflow.types.UDF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmBsnUdf5Ver14
implements OFOxmBsnUdf5 {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmBsnUdf5Ver14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 8;
    private static final UDF DEFAULT_VALUE = UDF.ZERO;
    private final UDF value;
    static final OFOxmBsnUdf5Ver14 DEFAULT = new OFOxmBsnUdf5Ver14(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmBsnUdf5Ver14Funnel FUNNEL = new OFOxmBsnUdf5Ver14Funnel();
    static final Writer WRITER = new Writer();

    OFOxmBsnUdf5Ver14(UDF value) {
        if (value == null) {
            throw new NullPointerException("OFOxmBsnUdf5Ver14: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 203268L;
    }

    @Override
    public UDF getValue() {
        return this.value;
    }

    @Override
    public MatchField<UDF> getMatchField() {
        return MatchField.BSN_UDF5;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<UDF> getCanonical() {
        return this;
    }

    @Override
    public UDF getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.4");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFOxmBsnUdf5.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmBsnUdf5Ver14(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmBsnUdf5Ver14 other = (OFOxmBsnUdf5Ver14)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmBsnUdf5Ver14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFOxmBsnUdf5Ver14 message) {
            bb.writeInt(203268);
            message.value.write4Bytes(bb);
        }
    }

    static class OFOxmBsnUdf5Ver14Funnel
    implements Funnel<OFOxmBsnUdf5Ver14> {
        private static final long serialVersionUID = 1L;

        OFOxmBsnUdf5Ver14Funnel() {
        }

        public void funnel(OFOxmBsnUdf5Ver14 message, PrimitiveSink sink) {
            sink.putInt(203268);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmBsnUdf5> {
        Reader() {
        }

        @Override
        public OFOxmBsnUdf5 readFrom(ByteBuf bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != 203268) {
                throw new OFParseError("Wrong typeLen: Expected=0x31a04L(0x31a04L), got=" + typeLen);
            }
            UDF value = UDF.read4Bytes(bb);
            OFOxmBsnUdf5Ver14 oxmBsnUdf5Ver14 = new OFOxmBsnUdf5Ver14(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmBsnUdf5Ver14);
            }
            return oxmBsnUdf5Ver14;
        }
    }

    static class Builder
    implements OFOxmBsnUdf5.Builder {
        private boolean valueSet;
        private UDF value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 203268L;
        }

        @Override
        public UDF getValue() {
            return this.value;
        }

        @Override
        public OFOxmBsnUdf5.Builder setValue(UDF value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<UDF> getMatchField() {
            return MatchField.BSN_UDF5;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<UDF> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.4");
        }

        @Override
        public UDF getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.4");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFOxmBsnUdf5 build() {
            UDF value;
            UDF uDF = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmBsnUdf5Ver14(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmBsnUdf5.Builder {
        final OFOxmBsnUdf5Ver14 parentMessage;
        private boolean valueSet;
        private UDF value;

        BuilderWithParent(OFOxmBsnUdf5Ver14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 203268L;
        }

        @Override
        public UDF getValue() {
            return this.value;
        }

        @Override
        public OFOxmBsnUdf5.Builder setValue(UDF value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<UDF> getMatchField() {
            return MatchField.BSN_UDF5;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<UDF> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.4");
        }

        @Override
        public UDF getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.4");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFOxmBsnUdf5 build() {
            UDF value;
            UDF uDF = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmBsnUdf5Ver14(value);
        }
    }
}

