/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFFlowMod;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.ver14.OFFlowAddVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFFlowDeleteStrictVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFFlowDeleteVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFFlowModifyStrictVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFFlowModifyVer14;
import org.projectfloodlight.openflow.types.TableId;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.types.U64;

abstract class OFFlowModVer14 {
    static final byte WIRE_VERSION = 5;
    static final int MINIMUM_LENGTH = 56;
    public static final Reader READER = new Reader();

    OFFlowModVer14() {
    }

    static class Reader
    implements OFMessageReader<OFFlowMod> {
        Reader() {
        }

        @Override
        public OFFlowMod readFrom(ByteBuf bb) throws OFParseError {
            if (bb.readableBytes() < 56) {
                return null;
            }
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 5) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_14(5), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 14) {
                throw new OFParseError("Wrong type: Expected=OFType.FLOW_MOD(14), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 56) {
                throw new OFParseError("Wrong length: Expected to be >= 56, was: " + length);
            }
            U32.f(bb.readInt());
            U64.ofRaw(bb.readLong());
            U64.ofRaw(bb.readLong());
            TableId.readByte(bb);
            short command = bb.readByte();
            bb.readerIndex(start);
            switch (command) {
                case 0: {
                    return OFFlowAddVer14.READER.readFrom(bb);
                }
                case 3: {
                    return OFFlowDeleteVer14.READER.readFrom(bb);
                }
                case 4: {
                    return OFFlowDeleteStrictVer14.READER.readFrom(bb);
                }
                case 1: {
                    return OFFlowModifyVer14.READER.readFrom(bb);
                }
                case 2: {
                    return OFFlowModifyStrictVer14.READER.readFrom(bb);
                }
            }
            throw new OFParseError("Unknown value for discriminator command of class OFFlowModVer14: " + command);
        }
    }
}

