/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvVlanVid;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.VlanVid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvVlanVidVer14
implements OFBsnTlvVlanVid {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvVlanVidVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 6;
    private static final VlanVid DEFAULT_VALUE = VlanVid.ZERO;
    private final VlanVid value;
    static final OFBsnTlvVlanVidVer14 DEFAULT = new OFBsnTlvVlanVidVer14(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFBsnTlvVlanVidVer14Funnel FUNNEL = new OFBsnTlvVlanVidVer14Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvVlanVidVer14(VlanVid value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvVlanVidVer14: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 6;
    }

    @Override
    public VlanVid getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFBsnTlvVlanVid.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvVlanVidVer14(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvVlanVidVer14 other = (OFBsnTlvVlanVidVer14)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvVlanVidVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvVlanVidVer14 message) {
            bb.writeShort(6);
            bb.writeShort(6);
            message.value.write2Bytes(bb);
        }
    }

    static class OFBsnTlvVlanVidVer14Funnel
    implements Funnel<OFBsnTlvVlanVidVer14> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvVlanVidVer14Funnel() {
        }

        public void funnel(OFBsnTlvVlanVidVer14 message, PrimitiveSink sink) {
            sink.putShort((short)6);
            sink.putShort((short)6);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvVlanVid> {
        Reader() {
        }

        @Override
        public OFBsnTlvVlanVid readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 6) {
                throw new OFParseError("Wrong type: Expected=0x6(0x6), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 6) {
                throw new OFParseError("Wrong length: Expected=6(6), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            VlanVid value = VlanVid.read2Bytes(bb);
            OFBsnTlvVlanVidVer14 bsnTlvVlanVidVer14 = new OFBsnTlvVlanVidVer14(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvVlanVidVer14);
            }
            return bsnTlvVlanVidVer14;
        }
    }

    static class Builder
    implements OFBsnTlvVlanVid.Builder {
        private boolean valueSet;
        private VlanVid value;

        Builder() {
        }

        @Override
        public int getType() {
            return 6;
        }

        @Override
        public VlanVid getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvVlanVid.Builder setValue(VlanVid value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvVlanVid build() {
            VlanVid value;
            VlanVid vlanVid = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvVlanVidVer14(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvVlanVid.Builder {
        final OFBsnTlvVlanVidVer14 parentMessage;
        private boolean valueSet;
        private VlanVid value;

        BuilderWithParent(OFBsnTlvVlanVidVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 6;
        }

        @Override
        public VlanVid getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvVlanVid.Builder setValue(VlanVid value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvVlanVid build() {
            VlanVid value;
            VlanVid vlanVid = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvVlanVidVer14(value);
        }
    }
}

