/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvRateLimit;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvRateLimitVer14
implements OFBsnTlvRateLimit {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvRateLimitVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 8;
    private static final long DEFAULT_VALUE = 0L;
    private final long value;
    static final OFBsnTlvRateLimitVer14 DEFAULT = new OFBsnTlvRateLimitVer14(0L);
    static final Reader READER = new Reader();
    static final OFBsnTlvRateLimitVer14Funnel FUNNEL = new OFBsnTlvRateLimitVer14Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvRateLimitVer14(long value) {
        this.value = U32.normalize(value);
    }

    @Override
    public int getType() {
        return 116;
    }

    @Override
    public long getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFBsnTlvRateLimit.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvRateLimitVer14(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvRateLimitVer14 other = (OFBsnTlvRateLimitVer14)obj;
        return this.value == other.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.value ^ this.value >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvRateLimitVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvRateLimitVer14 message) {
            bb.writeShort(116);
            bb.writeShort(8);
            bb.writeInt(U32.t(message.value));
        }
    }

    static class OFBsnTlvRateLimitVer14Funnel
    implements Funnel<OFBsnTlvRateLimitVer14> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvRateLimitVer14Funnel() {
        }

        public void funnel(OFBsnTlvRateLimitVer14 message, PrimitiveSink sink) {
            sink.putShort((short)116);
            sink.putShort((short)8);
            sink.putLong(message.value);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvRateLimit> {
        Reader() {
        }

        @Override
        public OFBsnTlvRateLimit readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 116) {
                throw new OFParseError("Wrong type: Expected=0x74(0x74), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long value = U32.f(bb.readInt());
            OFBsnTlvRateLimitVer14 bsnTlvRateLimitVer14 = new OFBsnTlvRateLimitVer14(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvRateLimitVer14);
            }
            return bsnTlvRateLimitVer14;
        }
    }

    static class Builder
    implements OFBsnTlvRateLimit.Builder {
        private boolean valueSet;
        private long value;

        Builder() {
        }

        @Override
        public int getType() {
            return 116;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvRateLimit.Builder setValue(long value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvRateLimit build() {
            long value = this.valueSet ? this.value : 0L;
            return new OFBsnTlvRateLimitVer14(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvRateLimit.Builder {
        final OFBsnTlvRateLimitVer14 parentMessage;
        private boolean valueSet;
        private long value;

        BuilderWithParent(OFBsnTlvRateLimitVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 116;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvRateLimit.Builder setValue(long value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvRateLimit build() {
            long value = this.valueSet ? this.value : this.parentMessage.value;
            return new OFBsnTlvRateLimitVer14(value);
        }
    }
}

